<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;

class ClearTranslationCacheByLocaleCountry extends Command
{
    protected $signature = 'cache:clear-translation {locale} {country}';
    protected $description = 'Clear translation cache entries for a specific locale and country.';

    public function handle()
    {
        $locale = $this->argument('locale');
        $country = $this->argument('country');

        // Path to the cache directory used by the file cache driver
        $cachePath = storage_path('framework/cache/data');
        $cacheFiles = File::allFiles($cachePath);

        $deletedFilesCount = 0;

        foreach ($cacheFiles as $file) {
            // Read the content of the cache file
            $fileContents = File::get($file->getPathname());
            // Check if the file contains the locale and country information
            if (strpos($fileContents, $locale) !== false && strpos($fileContents, $country) !== false) {
                // If the file contains both locale and country, delete it
                File::delete($file->getPathname());
                $deletedFilesCount++;
            }
        }

        if ($deletedFilesCount > 0) {
            $this->info("Deleted {$deletedFilesCount} translation cache files for locale '{$locale}' and country '{$country}'.");
        } else {
            $this->info("No translation cache files found for locale '{$locale}' and country '{$country}'.");
        }

        return 0;
    }
}
