<?php

namespace App\Console\Commands;

use App\Domain\Link\Models\Link;
use App\Jobs\TakeScreenshotJob;
use Illuminate\Console\Command;

class TakeScreenShot extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:take-screen-shot';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $links = Link::all();
        foreach ($links as $link) {
            TakeScreenshotJob::dispatch($link);
            $this->info("ScreenShot Taken '{$link}'");
        }
    }
}
