<?php

namespace App\Domain\Core\Models\Administration;

use App\Domain\Core\Models\Company;
use App\Domain\Order\Models\Order;
use App\Domain\Order\Models\WenchRequest;
use App\Domain\User\Models\Address;
use App\Domain\User\Models\FcmToken;
use App\Domain\User\Models\UserAddress;
use App\Domain\User\Models\UserCar;
use App\Support\Concerns\HasFactory;
use App\Support\Traits\HasPassword;
use Bavix\Wallet\Interfaces\Confirmable;
use Bavix\Wallet\Interfaces\Wallet;
use Bavix\Wallet\Traits\CanConfirm;
use Bavix\Wallet\Traits\HasWallet;
use HyperPay\Traits\ManageUserTransactions;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable implements HasMedia, Wallet, Confirmable
{
    use HasApiTokens;
    use HasFactory;
    use Notifiable;
    use HasRoles;
    use HasPassword;
    use InteractsWithMedia;
    use ManageUserTransactions;
    use HasWallet;
    use CanConfirm;
    use SoftDeletes;


    protected $hidden = ['password', 'remember_token'];

    protected $with = ['media'];
    protected $guarded = [];
    protected $dates = ['created_at', 'updated_at', 'last_seen'];

    public function devices(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany(FcmToken::class, 'user_id');
    }

    public function isAdmin()
    {
        return $this->hasRole('Super Admin');
    }

    public function getAvatarAttribute()
    {
        return !empty($this->getFirstMediaUrl()) ? $this->getFirstMediaUrl() :
            'https://ui-avatars.com/api/?background=0D8ABC&color=fff&name=' . $this->name;
    }

    public function getNameAttribute($value)
    {

        return ($value) ? $value : $this->first_name . ' ' . $this->last_name;
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function routeNotificationForMsegat()
    {
        return $this->phone;
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}
