<?php

namespace App\Http\Controllers\API\Job;

use App\Domain\Job\Models\Job;
use App\Http\Controllers\API\ApiController;
use App\Http\Resources\API\Job\JobResource;
use App\Http\Resources\API\Job\OfferResource;
use Illuminate\Http\Request;

class JobController extends ApiController
{
    public function jobs(Request $request)
    {
        $jobs = Job::ActiveCompany()->when($request->company_id, function ($query) use ($request) {
            return $query->where('user_id', $request->company_id);
        })->get();

        return $this->sendResponse(
            JobResource::paginate($jobs),
            __('Jobs retrieved Successfully')
        );
    }
}
