<?php

namespace App\Http\Controllers\Dashboard\Core\Administration;

use App\Domain\Core\Datatables\Administration\UserDatatable;
use App\Domain\Core\Enums\CorePermissions;
use App\Domain\Core\Models\Administration\User;
use App\Domain\Core\Models\City;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Http\Requests\Dashboard\Core\Administration\UserRequest;
use App\Support\Dashboard\Crud\WithCrud;
use HsmFawaz\UI\Services\RolesAndPermissions\RolesEnum;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Arr;
use Spatie\Permission\Models\Role;

class UserController extends DashboardController
{
    use WithCrud;

    protected string $name = 'Users';
    protected string $path = 'dashboard.core.administration.users';
    protected string $model = User::class;
    protected string $datatable = UserDatatable::class;

    protected string $formRequest = UserRequest::class;
    protected array $permissions = [CorePermissions::class, 'users'];

    protected function formData(?Model $model = null): array
    {
        return [
            'selected' => $model?->getRoleNames(),
            'cities' => toMap(City::get(), 'id', 'title'),
            'roles' => toMap(Role::where('guard_name', 'web')
                ->whereNotIn('name', RolesEnum::toValues())
                ->get(['id', 'name']), 'name'),
        ];
    }


    protected function storeAction(array $validated)
    {
        $avatar = Arr::pull($validated, 'avatar');
        $business_card = Arr::pull($validated, 'business_card');
        $model = User::create($validated);
        $model->syncRoles('user');
        $avatar && $model->addMedia($avatar)->toMediaCollection('avatar');
        $business_card && $model->addMedia($business_card)
            ->toMediaCollection('business_card');
    }

    protected function updateAction(array $validated, Model $model)
    {
        $avatar = Arr::pull($validated, 'avatar');
        $business_card = Arr::pull($validated, 'business_card');
        $model->update($validated);
        if ($avatar instanceof UploadedFile) {
            $model->clearMediaCollection('avatar');
            $model->addMedia($avatar)->toMediaCollection('avatar');
        }

        if ($business_card instanceof UploadedFile) {
            $model->clearMediaCollection('business_card');
            $model->addMedia($business_card)->toMediaCollection('business_card');
        }
    }
}
