<?php

namespace App\Http\Controllers\Dashboard\Core;

use App\Domain\Core\Datatables\SettingDatatable;
use App\Domain\Core\Enums\CorePermissions;
use App\Domain\Core\Models\Setting;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Support\Dashboard\Crud\WithCrud;
use App\Support\Dashboard\Crud\WithForm;
use App\Support\Dashboard\Crud\WithStore;
use Illuminate\Database\Eloquent\Model;

class SettingController extends DashboardController
{
    use WithCrud;

    protected string $name = 'Settings';
    protected string $path = 'dashboard.core.settings';

    protected string $datatable = SettingDatatable::class;
    protected array $permissions = [CorePermissions::class, 'settings'];

    protected string $model = Setting::class;

    public function __construct()
    {
        $this->middleware('can:settings');
    }

    public function index()
    {
        return view($this->path . '.index');
    }

    public function store()
    {
        $data = request()->except('_token');
        foreach ($data as $key => $val) {
            Setting::add($key, $val, Setting::getDataType($key));
        }

        return $this->successfulRequest();
    }

    protected function rules()
    {
        return [

        ];
    }

    protected function formData(?Model $model = null): array
    {
        return [

        ];
    }
}
