<?php

namespace App\Http\Controllers\Dashboard\Core;

use App\Domain\Core\Datatables\TransactionDatatable;
use App\Domain\Core\Enums\CorePermissions;
use App\Domain\Core\Models\Branch;
use App\Domain\Core\Models\Transaction;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Support\Dashboard\Crud\WithDatatable;
use App\Support\Dashboard\Crud\WithDestroy;
use App\Support\Dashboard\Crud\WithForm;
use App\Support\Dashboard\Crud\WithStore;
use App\Support\Dashboard\Crud\WithUpdate;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class TransactionController extends DashboardController
{
    use WithDatatable, WithForm, WithStore, WithUpdate, WithDestroy;

    protected string $name = 'Transaction';
    protected string $path = 'dashboard.core.transactions';
    protected string $datatable = TransactionDatatable::class;
    protected string $model = Transaction::class;
    protected array $permissions = [CorePermissions::class, 'transactions'];


    protected function rules()
    {
        return [

        ];
    }

    public function index()
    {
        $data = $this->formData();
        return $this->datatablePage($this->getDatatable(), $data);
    }

    protected function formData(?Model $model = null): array
    {
        $paymentMethods = [
            'visa' => __('Visa'),
            'tamara' => __('Tamara'),
            'mada' => __('Mada'),
            'applepay' => __('Apple Pay'),
            'cash_on_delivery' => __('cash on delivery'),
        ];
        return [
            'paymentMethods' => $paymentMethods,
            'branches' => Cache::rememberForever('branches_cache_key', function () {
                return toMap(Branch::get(), 'id', 'title');
            }),
        ];
    }
}
