<?php

namespace App\Http\Controllers\Dashboard\User;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Support\Dashboard\Crud\WithDatatable;
use App\Support\Dashboard\Crud\WithDestroy;
use App\Domain\Core\Enums\CorePermissions;
use App\Support\Dashboard\Crud\WithForm;
use App\Support\Dashboard\Crud\WithStore;
use App\Support\Dashboard\Crud\WithUpdate;
use Illuminate\Database\Eloquent\Model;
use App\Domain\User\Datatables\UserAddressDatatable;
use App\Domain\User\Models\UserAddress;

class UserAddressController extends DashboardController
{
    use WithDatatable,  WithForm , WithStore ,WithUpdate , WithDestroy;

    protected string $name = 'UserAddress';
    protected string $path = 'dashboard.user.user-addresses';
    protected string $datatable = UserAddressDatatable::class;
    protected string $model = UserAddress::class;
    protected array $permissions = [CorePermissions::class, 'permission_name'];


    protected function rules()
    {
        return [

        ];
    }

    protected function formData(?Model $model = null): array
    {
        return [

        ];
    }
}
