<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class OldSubmitFormApiController extends Controller
{
    const ANIME_CAMPAIGN_ID = 15048;
    const LEADS_DIGGERS_LINK_ID = 108;
    const ANIME_KEY = "TVRBMU56VmZOekl4WHpFd05UYzFYdz09";
    const ANIME_PASSWORD = "0EqyCtjrpc";
    const ANIME_URL = "https://tracker.anmepi.com/repost.php?act=register";
    const LEADS_DIGGERS_URL = "https://tracking.leadsdiggers.com/api/v3/integration?api_token=0NBu8CIqKi77nQO7bWMec7mJELGwO2EHHI0q5QslgnssDEm0Q2SrMpALeVEV";
    public function SubmitForm(Request $request)
    {
        $country = request('country');
        $validator = Validator::make($request->all(), [
            'first_name' => 'required|string',
            'last_name' => 'required|string',
            'email' => 'required|email',
            'phone' => 'required|string',
            'country_code' => 'required|string',
            'country_name' => 'required|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['success' => false, 'message' => googleTrans($validator->errors()->first(), countryLang($country)), 'data' => null]);
        }

        $countryRatios = [
            'us' => [
                'anime' => 100,
                'leads_diggers' => 0,
            ],
            'fr' => [
                'anime' => 30,
                'leads_diggers' => 70,
            ],
        ];

        $defaultRatios = [
            'anime' => 100,
            'leads_diggers' => 0,
        ];


        $ratios = $countryRatios[$request->input('country_name')] ?? $defaultRatios;

        $endpoints = [
            [
                'type' => 'anime',
                'percentage' => $ratios['anime'],
            ],
            [
                'type' => 'leads_diggers',
                'percentage' => $ratios['leads_diggers'],
            ],
        ];

        $random = mt_rand(1, 100);
        $selectedEndpoint = null;
        $cumulativePercentage = 0;
        foreach ($endpoints as $endpoint) {
            $cumulativePercentage += $endpoint['percentage'];
            if ($random <= $cumulativePercentage) {
                $selectedEndpoint = $endpoint;
                break;
            }
        }
        try {
            if ($selectedEndpoint['type'] === 'anime') {
                return $this->handleAnimeAPI($country);
            } else {
                return $this->handleLeadsDiggersAPI($country);
            }
        } catch (\Exception $e) {
            \Log::error('API Request Failed', ['error' => $e->getMessage(), 'trace' => $e->getTrace()]);
            return response()->json(['success' => false, 'message' => $e->getMessage(), 'data' => null], 500);
        }
    }

    private function handleAnimeAPI($country)
    {
        list($firstname,
            $lastname,
            $email,
            $phone,
            $country_code,
            $country_name,
            $ip,
            $language,
            $pageName) = $this->AllData(request());

        $request_data = [
            'ApiKey' => self::ANIME_KEY,
            'ApiPassword' => self::ANIME_PASSWORD,
            'Email' => $email,
            'FirstName' => $firstname,
            'LastName' => $lastname,
            'IP' => $ip,
            'CampaignID' => self::ANIME_CAMPAIGN_ID,
            'PhoneNumber' => $country_code . $phone,
            'Page' => $pageName,
            'brand' => $pageName,
            'Language' => $language,
        ];
        $response = Http::asForm()->post(self::ANIME_URL, $request_data);

        $redirectCountryName = countryLanguageMapping()[$country_name] ?? $country;

        if ($response->successful()) {
            $data = $response->json();

            if (isset($data['ret_code'])) {
                switch ($data['ret_code']) {
                    case "404":
                        $message = match ($data['ret_message']) {
                            "Invalid Phone" => googleTrans('Invalid Phone', countryLang($country)),
                            "Invalid Email" => googleTrans('Invalid Email', countryLang($country)),
                            "No brand found" =>googleTrans('No brand found', countryLang($country)) ,
                            default => googleTrans('Unknown error', countryLang($country)),
                        };
                        return response()->json(['success' => false, 'message' => googleTrans($message, countryLang($country)), 'data' => null], 200);
                    case "409":
                        return response()->json(['success' => false, 'type' => 'duplicate', 'message' => googleTrans('Duplicate Lead!', countryLang($country)), 'data' => null], 200);
                    case "201":
                        return response()->json(['success' => false, 'type' => 'brand_closed', 'url' => url(countryRedirectOnError($redirectCountryName)), 'message' => googleTrans('Brand is closed now', countryLang($country)), 'data' => null], 200);
                    case "200":
                        return response()->json(['success' => true, 'url' => route('thank-you', ['country' => $redirectCountryName, 'redirect_url' => urlencode($data['url'])]), 'data' => null], 200);
                }
            }
        }
        return response()->json(['success' => false, 'message' => $response->body()], $response->status());
    }

    private function handleLeadsDiggersAPI($country)
    {
        list($firstname,
            $lastname,
            $email,
            $phone,
            $country_code,
            $country_name,
            $ip,
            $language,
            $pageName) = $this->AllData(request());
        $request_data = [
            'link_id' => self::LEADS_DIGGERS_LINK_ID,
            'email' => $email,
            'fname' => $firstname . ' ' . $lastname,
            'ip' => $ip,
            'fullphone' =>'+'.$country_code . $phone,
            'source' => $pageName,
            'country' => Str::upper($country_name),
            'language' => $language,
        ];

        $response = Http::asForm()->post(self::LEADS_DIGGERS_URL, $request_data);
        if ($response->successful()) {
            $data = $response->json();
            if($data['success']){
                return response()->json(['success' => true, 'url' => route('thank-you', ['country' => $country, 'redirect_url' => urlencode($data['autologin'])]), 'data' => null], 200);
            }else{
                return response()->json(['success' => false, 'message' => $data['message']], $response->status());
            }

        }
        return response()->json(['success' => false, 'message' => $response->body()], $response->status());
    }

    /**
     * @param Request $request
     * @return void
     */
    protected function AllData(Request $request)
    {

        $firstname = $request->input('first_name');
        $lastname = $request->input('last_name');
        $email = $request->input('email');
        $phone = str_replace(' ', '', $request->input('phone'));
        $country_code = $request->input('country_code');
        $country_name = $request->input('country_name');
        $ip = $request->header('CF-Connecting-IP') ?? $request->header('X-Forwarded-For') ?? $request->ip();
        $language = strtoupper(substr($request->server('HTTP_ACCEPT_LANGUAGE', 'en'), 0, 2));
        $pageName = env('Website_name', 'test name');
        return [
            $firstname,
            $lastname,
            $email,
            $phone,
            $country_code,
            $country_name,
            $ip,
            $language,
            $pageName,
        ];
    }
}
