<?php

namespace App\Http\Controllers\Frontend\Ship;

use App\Domain\Order\Actions\OrderChangeStatusAction;
use App\Domain\Order\Models\Order;
use App\Domain\Order\OrderStatus\Enums\SparePartOrderStatusEnum;
use App\Domain\Ship\Enums\ShipStatusEnum;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;

class ShipController extends Controller
{
    public function webHook()
    {
        $order = Order::where('order_num', request('OrderRef'))->firstOrFail();
        $status = ShipStatusEnum::from(request('OrderStatusId') ?? 3);
        $statusValue = $status->value;
        $statusLabel = $status->label;
        // Change Status of Ship
        $order->ship()->update([
            'status' => $statusValue
        ]);
        Log::info('Shipment Status Changed');
        Log::info('order_num : ' . request('OrderRef'));
        Log::info($statusLabel);

        if ($statusValue == 4) { // on_delivery

            $changeStatus = (new OrderChangeStatusAction())($order, SparePartOrderStatusEnum::on_delivery()->label);
            Log::info('order Status Changed From ship');
            Log::info('order_num : ' . request('OrderRef'));
            Log::info($statusLabel);
        }
        if ($statusValue == 5) { // delivered
            $changeStatus = (new OrderChangeStatusAction())($order, SparePartOrderStatusEnum::it_was_received()->label);
            Log::info('order Status Changed From ship');
            Log::info('order_num : ' . request('OrderRef'));
            Log::info($statusLabel);
        }

        return response()->json(['status' => true, 'message' => __('Shipment Status Changed')]);
    }
}
