<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
class CheckCountry
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $country = $request->route('country') ?? 'en';
        // If your "langs()" returns [ 'en', 'ar', 'fr', ... ],
        // this ensures the user subdomain is valid.
        if (!in_array($country, langs())) {
            abort(404);
        }

        return $next($request);
    }
}
