<?php

namespace App\Http\Requests\Dashboard\Core\Administration;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class UserRequest extends FormRequest
{
    public function rules()
    {
        $rules = [
            'first_name' => "required|string",
            'last_name' => "required|string",
            'notify' => "sometimes|nullable|string",
            'city_id' => "required|integer|exists:cities,id",
            'status' => "required|string|in:active,pending,banned",
            'phone' => 'required|string|max:15|unique:users,phone',
            'email' => 'required|email|max:255|unique:users,email',
            'password' => ['required', 'confirmed', Password::min(6)],
            'avatar' => 'sometimes|image|max:4000',
            'business_card' => 'sometimes|image|max:4000',
        ];

        if ($this->isMethod('PUT')) {
            $rules['password'] = ['nullable', 'confirmed', Password::min(6)];
            $rules['phone'] = 'required|max:255|unique:users,phone,' . $this->route('user');
            $rules['email'] = 'required|max:255|unique:users,email,' . $this->route('user');
        }

        return $rules;

    }
}
