<?php

namespace App\Http\Requests\Dashboard\Ship;

use Illuminate\Foundation\Http\FormRequest;

class ShipRequest extends FormRequest
{
    public function rules()
    {
        $rules = [
            'order_id' => 'required|integer|exists:orders,id',
            'sender_lat' => 'required|numeric',
            'sender_lng' => 'required|numeric',
            'sender_address' => 'required|string',
            'sender_phone' => 'required|string',
            'sender_name' => 'required|string',
            'sender_city' => 'required|integer',
            'recipient_lat' => 'required|numeric',
            'recipient_lng' => 'required|numeric',
            'recipient_address' => 'required|string',
            'recipient_phone' => 'required|string',
            'recipient_name' => 'required|string',
            'recipient_city' => 'required|integer',
            'order_note' => 'required|string',
            'order_pieces_count' => 'required|integer',
            'order_total_weight' => 'required|numeric|regex:/^\d+(\.\d{1,2})?$/',
            'amount' => 'required|numeric',
        ];
        return $rules;

    }
}
