<?php

namespace App\Http\Resources\API\Driver;

use App\Domain\Order\OrderStatus\Enums\AppointmentOrderStatusEnum;
use App\Domain\Order\OrderStatus\Enums\SparePartOrderStatusEnum;
use App\Domain\Order\OrderStatus\Enums\WenchOrderStatusEnum;
use App\Http\Resources\API\Order\ServiceOrderResource;
use App\Http\Resources\API\Job\OfferResource;
use App\Http\Resources\API\Order\SparePartOrderResource;
use App\Http\Resources\API\Order\SparePartResource;
use App\Http\Resources\API\User\VendorResource;
use App\Support\Traits\WithPagination;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class DriverResourcesWench extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {

        return [
            'id' => $this->id,
            'name' => $this->name,
            'phone' => $this->phone,
            'address' => $this->address,
            'lat' => $this->lat,
            'lng' => $this->lng,
            'last_updated_location' => $this->last_updated_location ?
                Carbon::parse($this->last_updated_location)->translatedFormat('D, M j, Y g:i A') : "",
            'avatar' => $this->getFirstMediaUrl('avatar'),
            'license_image' => $this->getFirstMediaUrl('license_image'),
            'identification_image' => $this->getFirstMediaUrl('identification_image'),
        ];
    }

}
