<?php

namespace App\Http\Resources\API\Driver;

use App\Domain\Order\OrderStatus\Enums\AppointmentOrderStatusEnum;
use App\Domain\Order\OrderStatus\Enums\SparePartOrderStatusEnum;
use App\Domain\Order\OrderStatus\Enums\WenchOrderStatusEnum;
use App\Http\Resources\API\Order\ServiceOrderResource;
use App\Http\Resources\API\Job\OfferResource;
use App\Http\Resources\API\Order\SparePartOrderResource;
use App\Http\Resources\API\Job\SparePartResource;
use App\Http\Resources\API\User\VendorResource;
use App\Support\Traits\WithPagination;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class DriverWenchRequestResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {

        return [
            'id' => $this->id,
            'order_num' => $this->order?->order_num,
            'customer_name' => $this->order?->user?->name,
            'distance' => (double)number_format($this->distance, 2),
        ];
    }

}
