<?php

namespace App\Http\Resources\API;

use App\Domain\Catalog\Models\Category;
use App\Domain\Catalog\Models\Product;
use App\Domain\Core\Models\Slider;
use App\Http\Resources\API\Catalog\CategoryResource;
use App\Http\Resources\API\Catalog\ProductResource;
use App\Http\Resources\API\Core\SliderResource;
use Illuminate\Http\Resources\Json\JsonResource;

class HomeResource extends JsonResource
{

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $data = [
            'type' => $this->type,
            'title' => (app()->getLocale() == 'ar') ? $this->title_ar : $this->title_en,
            'position' => $this->position,
            'categories_ids' => $this->categories_ids ?? 0,
            'products' => null,
            'categories' => null,
            'sliders' => null,
        ];
        if ($this->type == 'product' && isset($this->categories_ids)) {
            $products = Product::whereHas('categories', function ($query) {
                $query->whereIn('category_id', $this->categories_ids);
            })->limit(12)->get();
            $data['products'] = ProductResource::collection($products);
        }

        if ($this->type == 'category' && isset($this->categories_ids)) {
            $categories = Category::with('children')->find($this->categories_ids);
            $data['categories'] = CategoryResource::collection($categories);
        }
        if ($this->type == 'slider' && isset($this->sliders_ids)) {
            $sliders = Slider::find($this->sliders_ids);
            $data['sliders'] = SliderResource::collection($sliders);
        }
        return $data;

    }

}
