<?php

namespace App\Http\Resources\API\Job;

use App\Support\Traits\WithPagination;
use Illuminate\Http\Resources\Json\JsonResource;

class JobApplyResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {

        return [
            'id' => $this->id,
            'name' => $this->name ?? '',
            'email' => $this->email ?? '',
            'phone' => $this->phone ?? '',
            'previous_experiences' => $this->previous_experiences ?? '',
            'cv' => !empty($this->getFirstMediaUrl('cv')) ? $this->getFirstMediaUrl('cv') : '',
        ];
    }
}
