<?php

namespace App\Http\Resources\API\Offer;

use App\Support\Traits\WithPagination;
use Illuminate\Http\Resources\Json\JsonResource;

class OfferSparePartResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {

        return [
            'id' => $this->spare_part?->id,
            'title' => $this->spare_part?->title,
            'price_text' => $this->spare_part?->price,
            'car_model' => $this->spare_part?->car_model,
            'image' => (!empty($this->spare_part?->getFirstMediaUrl('image'))) ? $this->spare_part?->getFirstMediaUrl('image') : 'https://images.unsplash.com/photo-1617704548623-340376564e68',
        ];
    }
}
