<?php

namespace App\Http\Resources\API\Order;

use App\Domain\Marketing\Actions\ApplyVoucherAction;
use App\Support\Traits\WithPagination;
use Illuminate\Http\Resources\Json\JsonResource;

class VoucherResource extends JsonResource
{
    use WithPagination;

    public function __construct($voucher, $orderId)
    {
        parent::__construct($voucher);
        $this->orderId = $orderId; // Store the order ID
    }

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        $isValid = (new ApplyVoucherAction())->isValid($this->orderId, $this->resource);
        return [
            'id' => $this->id,
            'code' => $this->code,
            'is_valid' => $isValid['status'],
            'message' => $isValid['message'],
        ];
    }
}
