<?php

namespace App\Providers;

use App\Domain\Core\Models\Menu;
use App\Domain\NewsPost\Models\NewsPost;
use Bugsnag\BugsnagLaravel\Facades\Bugsnag;
use Carbon\Carbon;
use HsmFawaz\UI\Providers\UIServiceProvider;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\URL;

class AppServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->app->register(UIServiceProvider::class);
    }

    public function boot()
    {
        if (env('APP_ENV') !== 'local') { // Enforce HTTPS on non-local environments
        URL::forceScheme('https');
    }
        Model::preventLazyLoading(!App()->isProduction());
        Model::handleLazyLoadingViolationUsing(function ($model, $relation) {
            Bugsnag::notifyError("N+1 Query Detected", sprintf("N+1 Query Detected in %s::%s", get_class($model), $relation));

        });
        Validator::includeUnvalidatedArrayKeys();
        View::composer('ui::layout.master', static function ($view) {
            $routes = require resource_path('sidebar/sidebar.php');
            $view->with('sidebarRoutes', $routes);
        });

        View::composer('*', function ($view) {
            $country = request()->route('country')??'en'; // Get the first segment as the country
            if(request()->route('country') == 'about'
                || request()->route('country') == 'contact'
                || request()->route('country') == 'terms-of-use'
                ||request()->route('country') == 'privacy-policy'
            ){
                $country = 'en';
            }

            $title = env('Website_title','website title'); // Get the first segment as the country
            $website_name = env('Website_name_'.$country,'Official Website'); // Get the first segment as the country
            $locale = session('locale','en'); // Get the first segment as the country

            $view->with('country', $country);
            $view->with('website_title', $title);
            $view->with('website_name', $website_name);
            $view->with('locale', $locale);
        });
    }
}
