<?php

namespace App\Support\HsmFireBase;

class FireBaseModel
{
    public array $androidTokens = [];

    public array $iosTokens = [];

    public function __construct(
        public string $type,
        public  $title,
        public  $message,
        public ?array $relatedData = null,
        public ?string $relatedID = null,
        public string $action = ''
    ) { }

    public function setTokens(array $tokens): void
    {
        $collection = collect($tokens);
        $this->iosTokens = $collection->where('type', 'ios')->pluck('token')->all();
        $this->androidTokens = $collection->where('type', 'android')->pluck('token')->all();
    }

    public function toData(): array
    {
        return [
            'type'         => $this->type,
            'title'        => $this->title,
            'message'      => $this->message,
            'tag'           => $this->relatedID,
            'related_data' => $this->relatedData,
            'icon'         => asset('icon.png'),
        ];
    }

    public function toMessage(): array
    {
        return [
            'title'        => $this->title,
            'body'         => $this->message,
            'tag'           => $this->relatedID,
            'click_action' => $this->action,
            'sound'        => 'default',
        ];
    }
}
