@props(['title' => '', 'route', 'breadcrumbs' => [], 'datatable', 'noActions' => false, 'parameters' => [], 'permission' => null])
<x-ui::layout :title="__($title)" :breadcrumbs="$breadcrumbs">

    {{ $prepend ?? '' }}    

    <div class="card">
        <div class="card-body overflow-auto">
            @if (Route::has($route . '.destroy.all'))
                {!! Form::open(['id' => 'multi-delete-form', 'url' => route($route . '.destroy.all'), 'method' => 'delete']) !!}
            @endif
            {{$datatable->table(['class'=>'table dataTable table-row-bordered gy-5 cell-border ']) }}

            @if (Route::has($route . '.destroy.all'))
                {!! Form::close() !!}
            @endif
        </div>
    </div>

    {{ $append ?? '' }}

    @if (!$noActions)
        <x-slot:actions>
            @isset($actions)
                {{ $actions }}
            @else
                @if ($permission === null || $permission->can('create'))
                    <a href="{{ route("{$route}.create", $parameters) }}" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> {{ __('Create') }}
                    </a>
                @endif
            @endif
        </x-slot:actions>
    @endif
    <x-slot:header>

        <link href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css"
              rel="stylesheet">
        <style>
            a {
                text-decoration: none !important;
            }

            .buttons-print {
                margin: 0 5px;
                padding: 5px 20px !important;
            }

            @if (app()->getLocale() == 'ar')
            #base-datatable-table thead tr th {
                text-align: right;
            }

            @endif
            #base-datatable-table td {
                text-align: center;
            }
        </style>
        {{ $header ?? '' }}
    </x-slot:header>
    <x-slot:scripts>

        <script
                src="{{ asset('vendor/hsmfawaz/ui/metronic/assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>
        <script src="https://cdn.datatables.net/buttons/1.5.2/js/dataTables.buttons.min.js"
                type="text/javascript"></script>
        <script src="{{ asset('vendor/js/jquery.min.js') }}" type="text/javascript"></script>
        <script src="https://cdn.datatables.net/v/dt/dt-1.13.6/r-2.5.0/datatables.min.js"
                type="text/javascript"></script>
        <script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js" type="text/javascript"></script>

        <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"
                type="text/javascript"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js" type="text/javascript"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"
                type="text/javascript"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"
                type="text/javascript"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js" type="text/javascript"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js" type="text/javascript"></script>
        <script src="{{ asset('vendor/datatables/buttons.server-side.js') }}"></script>

        {{ $datatable->scripts() }}

        <script>
            window.helper_trans = {
                title: '{{ __('Are you sure ?') }}',
                body: '{{ __('You wont be able to restore it again') }}',
                confirm: '{{ __('Yes, delete') }}',
                cancel: '{{ __('No, cancel') }}',
                done: '{{ __('done') }}',
                error: '{{ __('An error occurred while updating the status') }}',

            }

            function deleteRow(ts) {
                let url = $(ts).data('href');
                Swal.fire({
                    title: window.helper_trans.title,
                    text: window.helper_trans.body,
                    showCancelButton: true,
                    confirmButtonText: window.helper_trans.confirm,
                    cancelButtonText: window.helper_trans.cancel,
                    timer: undefined
                }).then((isConfirm) => {
                    if (isConfirm.value) {
                        $.post(url, {
                            _method: 'DELETE'
                        }).done(function (response) {
                            if (response.status) {
                                $('.dataTable').DataTable().ajax.reload();
                                Swal.fire("Good Job", response.data, "success");
                            } else {
                                Swal.fire("Failed!", 'Unexpected error occurred', "error");
                                console.log(response);
                            }
                        })
                    }
                });
            }

            $('#multiDeleteAll').on('click', function (e) {

                $('.item_checkbox_delete').each(function () {

                    if ($('#multiDeleteAll:checked').length == 0) {
                        $(this).prop('checked', false);
                    } else {
                        $(this).prop('checked', true);
                    }
                });
            });

            $(document).on('click', '.delBtn', function () {
                var item_checked = $('.item_checkbox_delete:checked').filter(":checked").length;
                if (item_checked > 0) {
                    Swal.fire({
                        title: window.helper_trans.title,
                        text: window.helper_trans.body,
                        showCancelButton: true,
                        confirmButtonText: window.helper_trans.confirm,
                        cancelButtonText: window.helper_trans.cancel,
                        timer: undefined
                    }).then((isConfirm) => {
                        if (isConfirm.value) {
                            $('#multi-delete-form').submit();
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        text: '{{ __('Please Select Item to Delete First') }}',
                        showCancelButton: false,
                        timer: undefined
                    });
                }

            });
        </script>


        <script>
            function changeModelStatus(event) {
                let switchElement = event.target;
                let checked = switchElement.checked;
                let id = switchElement.id.split("s_").pop();
                let url = switchElement.getAttribute("data-href");

                let status = checked ? 'active' : 'inactive';

                let data = {
                    id: id,
                    status: status
                };

                $.ajax({
                    url: url,
                    type: 'PUT',
                    contentType: 'application/json',
                    data: JSON.stringify(data),
                    success: function (response) {
                        Swal.fire({
                            title: response.message,
                            text: "",
                            timer: 3000,
                            width: "32rem",
                            padding: "",
                            showConfirmButton: false,
                            showCloseButton: true,
                            timerProgressBar: false,
                            toast: true,
                            icon: response.success ? "success" : "error",
                            position: "top-end",
                            iconHtml: '<i class="fas ' + (response.success ? 'fa-check-circle' :
                                'fa-times-circle') + '"></i>',
                            customClass: {
                                container: null,
                                popup: null,
                                header: null,
                                closeButton: "btn btn-light",
                                content: null,
                                input: "form-control",
                                confirmButton: "btn btn-primary",
                                cancelButton: "btn btn-light"
                            }
                        });
                    },
                    error: function (error) {
                        Swal.fire({
                            title: "Error",
                            text: window.helper_trans.error,
                            timer: 3000,
                            width: "32rem",
                            padding: "",
                            showConfirmButton: false,
                            showCloseButton: true,
                            timerProgressBar: false,
                            toast: true,
                            icon: "error",
                            position: "top-end",
                            iconHtml: '<i class="fas fa-times-circle"></i>',
                            customClass: {
                                container: null,
                                popup: null,
                                header: null,
                                closeButton: "btn btn-light",
                                content: null,
                                input: "form-control",
                                confirmButton: "btn btn-primary",
                                cancelButton: "btn btn-light"
                            }
                        });
                    }
                });

            }
        </script>

        {{ $scripts ?? '' }}
    </x-slot:scripts>
</x-ui::layout>
