@props(['name','options'=>[],'label'=>'','class' => "",'selected'=>null,'multiple'=>null,
'labelClass'=>null,
'errorName'=>null])
@php

    $errorName ??= dotted_string($name);
    $splitAttributes = explode(' ',$attributes);
    $invalidClass =$errors->has($errorName) ? 'is-invalid' : '';
    $defaultPlaceHolder = !$multiple ? __('Select').' '.__(':name',['name'=>$label]) : null;

    foreach ($options as $key => $value) {
        $options[$key] = __($value) ;
    }
   $properties = [
     'class'=>"{$invalidClass} form-control {$class}" ,
     'placeholder'=> $defaultPlaceHolder,
     ...$splitAttributes,
     'multiple'=>$multiple ,
     'id' => $name
    ];
@endphp
<div class="col-sm-12">
    <div class="form-group row no-gutters">
        <label
                class="col-sm-12 col-form-label text-left {{$labelClass}} {{ $errors->has($errorName) ? 'text-danger' : '' }}">
            {{ $label }}
            @if($attributes['required'])
                <span class="text-danger align-items-center">*</span>
            @endif
        </label>
        <div class="col-sm-12">
            {!! !$slot->isEmpty() ?  $slot : Form::select($name,$options,$selected,$properties) !!}
            @error($errorName)
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>

