<?php

namespace HsmFawaz\UI\Services\RolesAndPermissions\Roles;

use App\Domain\Core\Enums\CompanyPermissions;
use App\Domain\Core\Enums\CorePermissions;
use HsmFawaz\UI\Services\RolesAndPermissions\Concerns\HasPermissionMap;
use HsmFawaz\UI\Services\RolesAndPermissions\RolesEnum;
use Spatie\Permission\Models\Role;

class CompanyRole
{
    use HasPermissionMap;

    protected array $permissions = [
        CompanyPermissions::class,
    ];

    public function execute()
    {
        /** @var Role $role */
        $role = Role::updateOrCreate(['name' => RolesEnum::company()->value, 'guard_name' => 'web']);
        $role->givePermissionTo($this->getPermissionNames());
    }
}
