<?php

namespace HsmFawaz\UI\Services\RolesAndPermissions;

use App\Domain\Core\Enums\CorePermissions;
use HsmFawaz\UI\Services\RolesAndPermissions\Concerns\HasPermissionMap;
use HsmFawaz\UI\Services\RolesAndPermissions\Roles\CompanyRole;
use HsmFawaz\UI\Services\RolesAndPermissions\Roles\DriverRole;
use HsmFawaz\UI\Services\RolesAndPermissions\Roles\ManagerRole;
use HsmFawaz\UI\Services\RolesAndPermissions\Roles\SuperAdminRole;
use HsmFawaz\UI\Services\RolesAndPermissions\Roles\UserRole;
use Illuminate\Database\Seeder;

class RolesSeeder extends Seeder
{
    use HasPermissionMap;

    protected array $roles = [
        SuperAdminRole::class,
        UserRole::class,
        ManagerRole::class,
        CompanyRole::class,
    ];

    protected array $permissions = [
        CorePermissions::class,
    ];

    public function run()
    {
        $this->createPermissions();
        $this->seedRoles();
    }

    private function seedRoles()
    {
        foreach ($this->roles as $role) {
            (new $role())->execute();
        }
    }
}
