<?php

namespace Codebase\PageBuilder\Concerns;

use Codebase\PageBuilder\Models\EditablePage;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\MorphMany;

trait HasEditablePage
{
    abstract public function getTemplateId(): string;

    public function editablePages(): MorphMany
    {
        return $this->morphMany(EditablePage::class, 'editable');
    }

    public function scopeWithEditablePages(Builder $builder, string $locale)
    {
        return $builder->with([
            'editablePages' => function ($builder) use ($locale) {
                $builder->where('lang', $locale);
            },
        ]);
    }

    public function getEditablePageAttribute()
    {
        return $this->editablePages->first();
    }

    public function fetchEditablePage(?string $language = null)
    {
        return EditablePage::query()->firstOrCreate([
            'editable_id'   => $this->id,
            'editable_type' => $this->getMorphClass(),
            'lang'          => $language ?? app()->getLocale(),
        ]);
    }
}
