<?php

namespace Codebase\PageBuilder\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Support\Dashboard\Crud\WithDatatable;
use App\Support\Dashboard\Crud\WithDestroy;
use App\Support\Dashboard\Crud\WithForm;
use App\Support\Dashboard\Crud\WithStore;
use App\Support\Dashboard\Crud\WithUpdate;
use Codebase\PageBuilder\Concerns\WithEditablePage;
use Codebase\PageBuilder\Datatables\StaticPageDatatable;
use Codebase\PageBuilder\Editor\PersistPageContent;
use Codebase\PageBuilder\Models\EditablePage;
use Codebase\PageBuilder\Models\StaticPage;
use Collective\Html\FormFacade;
use Dotlogics\Grapesjs\App\Repositories\AssetRepository;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Str;

class StaticPageController extends DashboardController
{
    use WithDatatable, WithForm, WithStore, WithUpdate, WithDestroy;
    use  WithEditablePage;

    protected string $path = 'dashboard.core.static-pages';
    protected string $model = StaticPage::class;
    protected string $name = 'Page Builder';
    protected string $datatable = StaticPageDatatable::class;


    protected function rules()
    {   
        $staticPageId = request('staticPage'); // Assuming the route parameter name for the ID is 'static_page'
        
        return [
            'name' => 'required|array',
            'name.*' => 'required|string',
            'key' => [
                'alpha_dash',
                Rule::unique('static_pages', 'key')->ignore($staticPageId, 'id'),
            ],
        ];
    }

    public function show(StaticPage $staticPage)
    {
        return $this->showPageEditor($staticPage, true);
    }

    public function editablePage(Request $request, EditablePage $page)
    {
        PersistPageContent::persist(
            page: $page,
            html: $request->get('laravel-grapesjs-html'),
            css: $request->get('laravel-grapesjs-css')
        );
        
        $page->editable()->touch() ;

        return response()->noContent(200);
    }

    public function uploadMedia(Request $request, AssetRepository $assetRepository)
    {
        $this->validate($request, [
            'file' => 'required|array',
            'file.*' => 'required|file'
        ]);

        return response()->json([
            'data' => $assetRepository->uploadFilesFromRequest('file')
        ]);
    }

    public function create()
    {
        $data['route'] = $this->path;
        $data['formName'] = $this->name;
        $data['formBreadCrumbs'] = Str::of($this->path)
                                      ->explode('.')
                                      ->map(fn ($i) => __(Str::studly($i)))
                                      ->push(__('Create'));
        return view('dashboard.core.static-pages.create')->with($data) ;
        
    }


    public function edit($id)
    {   $model = ($this->model)::where('is_section' , false)->findOrFail($id) ; 
        $data['models'] = $model ; 
        $data['model'] = FormFacade::setModel($model);
        $data['route'] = $this->path;
        $data['formName'] = $this->name;
        $data['formBreadCrumbs'] = Str::of($this->path)
                                      ->explode('.')
                                      ->map(fn ($i) => __(Str::studly($i)))
                                      ->push(__('Update'));
        return view('dashboard.core.static-pages.edit')->with($data) ;
        
    }


    public function destroy($id)
    {
        $model = ($this->model)::where('is_section' , false)->findOrFail($id);
        $action = $this->destroyAction($model);

        return $action ?? $this->successfulRequest(asJson: true);
    }

}
