<?php

namespace Codebase\PageBuilder;

use Codebase\PageBuilder\Models\Page;

class PageBuilder
{
    public static function getPage(string $name, string $locale = null): Page
    {
        $locale ??= app()->getLocale();
        $ds = DIRECTORY_SEPARATOR;
        $basePath = resource_path('static-pages'.$ds.'static-page'.$ds.$name.$ds.$locale);
        $page = new Page();
        try {
            $page->html = \Illuminate\Support\Facades\File::get($basePath.$ds.'index.html');
            $page->css = \Illuminate\Support\Facades\File::get($basePath.$ds.'styles.css');
        } catch (\Exception $exception) {
            $page->css = $page->html = 'page not found';
        }

        return $page;
    }

    public static function addPlaceholder(string &$pageHtml, string $placeholder, string $value): void
    {
        $pageHtml = str_replace("[[$placeholder]]", $value, $pageHtml);
    }
}