<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit {{ $model->editor_page_title }}</title>
    @foreach ($editorConfig->getStyles() as $style)
        <link rel="stylesheet" href="{{ $style }}">
    @endforeach
  
    <style>
        * {
            margin: 0;
            padding: 0;
        }

        .gjs-pn-language-manager {
            left: 130px;
            top: 5px;
        }

        .nav-bar {
            background: #333;
            padding: 5px;
            color: white;
        }

        .nav-bar select {
            width: 100px;
            padding: 2px;
        }

    </style>
    <script>
        window.editorConfig = @json($editorConfig ?? []);

        Object.defineProperty(window, 'grapesjs', {
            value: {
                plugins: {
                    plugins: [],

                    /**
                     * Add new plugin. Plugins could not be overwritten
                     * @param {string} id Plugin ID
                     * @param {Function} plugin Function which contains all plugin logic
                     * @return {Function} The plugin function
                     * @example
                     * PluginManager.add('some-plugin', function(editor){
                     *   editor.Commands.add('new-command', {
                     *     run:  function(editor, senderBtn){
                     *       console.log('Executed new-command');
                     *     }
                     *   })
                     * });
                     */
                    add(id, plugin) {
                        if (this.plugins[id]) {
                            return this.plugins[id];
                        }

                        this.plugins[id] = plugin;

                        return plugin;
                    },

                    /**
                     * Returns plugin by ID
                     * @param  {string} id Plugin ID
                     * @return {Function|undefined} Plugin
                     * @example
                     * var plugin = PluginManager.get('some-plugin');
                     * plugin(editor);
                     */
                    get(id) {
                        return this.plugins[id];
                    },

                    /**
                     * Returns object with all plugins
                     * @return {Object}
                     */
                    getAll() {
                        return this.plugins;
                    },
                }
            }
        })
    </script>
</head>

<body>
<div class="nav-bar">
    <div>
        <label for="">Language : </label>
        <select id="languageSelector">
            <option {{ $currentLang === 'en' ? 'selected' : '' }} value="en">English</option>
            <option {{ $currentLang === 'ar' ? 'selected' : '' }} value="ar">العربية</option>
        </select>
    </div>
</div>

<div id="{{ str_replace('#', '', $editorConfig->container ?? 'editor') }}"></div>
<input type="hidden" id="PageBlocksCollection" value='@json($blocks ?? [])'>
<script>
    document.getElementById('languageSelector').addEventListener('change', function (el) {
        window.location.href = '{!! request()->fullUrlWithQuery(['language'=>'xxx']) !!}'.replace
        ('xxx', el.target.value)
    })
    window.dashboard = {
        fallback: '{{ $fallbackRoute ?? '' }}',
        blocks: JSON.parse(document.getElementById('PageBlocksCollection').value),
        withBasicBlocks: {{ $withBasicBlocks ? 'true' : 'false' }}
    }
</script>
@foreach ($editorConfig->getScripts() as $script)
    <script src="{{ $script }}"></script>
@endforeach
</body>
</html>
