@extends('layouts.app')
@section('title', $website_title .' | الشروط والأحكام')
@php( $meta_description = "اقرأ الشروط والأحكام الخاصة بـ ". $website_title.". توضح شروطنا حقوقك ومسؤولياتك وكيفية استخدام خدماتنا بشكل آمن وفعال.")

@section('content')
<div class="terms-and-conditions wf-section">
        <div class="w-container">
            <h1> الشروط والأحكام</h1>
            <div>
                <style>
                    table {
                        width: 100%;
                    }
    
                    table,
                    th,
                    td {
                        border: 1px solid;
                        border-collapse: collapse;
                    }
    
                    th,
                    td {
                        padding: 10px;
                    }
    
                    table td {
                        vertical-align: top;
                    }
    
                    .nested-list {
                        counter-reset: item;
                    }
    
                    .nested-list li {
                        display: block;
                    }
    
                    .nested-list li:before {
                        content: counters(item, '.') '. ';
                        counter-increment: item;
                    }
    
                    .legal-section {
                        text-align: left;
                    }
    
                    .legal-section h3 {
                        margin-top: 30px;
                        font-size: 24px;
                    }
    
                    .legal-section h4 {
                        font-size: 18px;
                    }
                </style>
                <p>
                    {{aiTrans('شكرًا لزيارتك موقعنا')}} <a href="{{ route('home', $country) }}"> الإلكتروني</a> {{aiTrans('(الموقع الإلكتروني) حيث وجدت الرابط لشروط وأحكام الاستخدام هذه ("الموقع الإلكتروني") وسياسة الخصوصية الخاصة بنا')}} <a href="{{ route('privacy', $country) }}">{{aiTrans('سياسة الخصوصية')}}</a> {{aiTrans('("سياسة الخصوصية"). يتم تشغيل هذا الموقع الإلكتروني والتحكم فيه من قبل')}} {{ $website_title }}{{aiTrans(' وأي شركات قابضة أو فرعية أو كيانات ذات صلة، ويشار إليها جميعًا باسم')}} {{ $website_title }}. {{aiTrans('الموقع الإلكتروني مملوك لنا
    (ويشار إليه مجتمعًا باسم "نحن" أو "خاصتنا") ويمكنك الاتصال بنا في أي وقت عبر البريد الإلكتروني')}}
                    إلى: <span >info{{ '@'.$website_title }}</span>
                </p>
                <p>
                    {{ aiTrans('باستخدامك للموقع الإلكتروني أو استخدامك لمنتجاتنا و/أو خدماتنا ("خدمات المورد" ويشار إليها مجتمعًا مع خدمات الاشتراك باسم "الخدمات")، فإنك توافق على الالتزام بشروط الاستخدام هذه ("الشروط") وسياسة الخصوصية الخاصة بنا. تتضمن هذه الشروط قواعد التشغيل والسياسات والمعلومات والشروط الإضافية الأخرى. نحتفظ بالحق في تعديل الشروط من وقت لآخر دون إشعار مسبق وفقًا لتقديرنا. من مسؤوليتك مراجعة هذه الصفحة بشكل دوري للتحديثات على الشروط، والتي ستصبح سارية بعد النشر. سيُعتبر استخدامك المستمر للموقع الإلكتروني بمثابة قبولك للشروط.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('يرجى مراجعة الشروط والأحكام الكاملة بعناية. إذا كنت لا توافق على أي جزء منها، فليس لديك إذن لاستخدام الخدمات أو الموقع الإلكتروني بأي شكل من الأشكال. نحتفظ بالحق في رفض الوصول إلى الخدمات و/أو الموقع الإلكتروني وفقًا لتقديرنا الحصري.', $locale) }}
                </p>
                <h3>{{ aiTrans('بدون استشارة استثمارية', $locale) }}</h3>
                <p>
                    {{ aiTrans('ما لم يُنص على خلاف ذلك صراحةً، لم يتم تصميم هذا الموقع الإلكتروني لتقديم استشارات مالية أو استثمارية شخصية. المعلومات المقدمة لا تأخذ في الاعتبار أهدافك الاستثمارية المحددة أو وضعك المالي أو احتياجاتك الاستثمارية.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('يجب عليك تقييم ما إذا كانت المعلومات الواردة في هذا الموقع الإلكتروني مناسبة لأهدافك الاستثمارية ووضعك المالي واحتياجاتك الاستثمارية. يجب عليك القيام بذلك قبل اتخاذ أي قرار استثماري بناءً على المعلومات المقدمة في هذا الموقع الإلكتروني. يمكنك إجراء هذا التقييم بنفسك أو بمساعدة مستشار مالي مستقل.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('ما لم يُنص على خلاف ذلك صراحةً، لا تشكل المعلومات الواردة في هذا الموقع الإلكتروني توصية باستثمار في أي منتجات أو خدمات مالية مقدمة من أي عضو في مجموعة شركاتنا.', $locale) }}
                </p>
                <h3>{{ aiTrans('المنتجات والخدمات', $locale) }}</h3>
                <p>
                    {{ aiTrans('ليست جميع المنتجات والخدمات المذكورة في هذا الموقع الإلكتروني مقدمة منا بالضرورة. تحديد أو استخدام أي منتجات أو خدمات أو مواقع إلكترونية أو شبكات تابعة لأطراف ثالثة لا يشكل توصية بهذه المنتجات أو الخدمات أو المواقع الإلكترونية أو الشبكات. قد يسمح لك هذا الموقع الإلكتروني بالوصول إلى مواقع إلكترونية أو شبكات مقدمة من أطراف أخرى غيرنا عبر رابط تشعبي أو رابط آخر.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('نحن لا نتحمل أي مسؤولية أو التزام من أي نوع تجاه أي مواد في أي موقع إلكتروني أو شبكة ليست تحت سيطرتنا المباشرة. أنت تقر بأن وصولك إلى هذه المواقع الإلكترونية أو الشبكات الأخرى عبر مثل هذا الرابط قد يلزمنا بتقديم معلومات معينة عنك لمالك ذلك الموقع الإلكتروني أو الشبكة. لا يُقصد بأي شيء في هذا الموقع الإلكتروني أن يكون، ولا يجب أن تفهمه على أنه، استشارة استثمارية أو مالية منا أو بواسطتنا.', $locale) }}
                </p>
                <h3>{{ aiTrans('النطاق والتعديل', $locale) }}</h3>
                <p>
                    {{ aiTrans('أنت توافق على الشروط الموضحة في هذا المستند فيما يتعلق باستخدام موقعنا الإلكتروني. تشكل هذه الشروط الاتفاق الكامل بينك وبيننا، وتحل محل جميع الاتفاقيات والتصريحات والضمانات والتفاهمات السابقة المتعلقة بالموقع الإلكتروني.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('يرجى ملاحظة أن هذه الشروط قد يتم تعديلها بشكل دوري. إذا قمنا بتعديل هذه الشروط، فسنخطرك بالخيارات المتاحة بموجب هذه التغييرات. بالإضافة إلى ذلك، سننشر إشعارًا يشير إلى التعديل. سيُعتبر استخدامك المستمر للموقع الإلكتروني و/أو خدماتنا بمثابة موافقتك الكاملة على الالتزام بالشروط والأحكام المحدثة السارية في ذلك الوقت. من مسؤوليتك التحقق بانتظام من هذه الصفحة للتحديثات و/أو التغييرات.', $locale) }}
                </p>
                <h3>{{ aiTrans('المتطلبات', $locale) }}</h3>
                <p>
                    {{ aiTrans('الموقع الإلكتروني وخدماتنا متاحة حصريًا للأفراد المؤهلين لإبرام عقود ملزمة قانونًا وفقًا للتشريعات المعمول بها. لا يُقصد بهما الاستخدام من قبل الأفراد الذين تقل أعمارهم عن ثمانية عشر (18) عامًا. إذا كان عمرك أقل من ثمانية عشر (18) عامًا، فليس لديك إذن لاستخدام و/أو الوصول إلى الموقع الإلكتروني و/أو الخدمات.', $locale) }}
                </p>
                <h3>{{ aiTrans('وصف الخدمات', $locale) }}</h3>
                <p>
                    <i>{{ aiTrans('خدمات الاشتراك:', $locale) }}</i> {{ aiTrans('عند التسجيل في الموقع الإلكتروني والحصول على موافقتنا، يمكنك الحصول، أو محاولة الحصول، على خدمات الاشتراك مقابل رسوم أو بدون رسوم. توفر هذه الخدمات محتوى عبر البريد الإلكتروني والنص ومواد أخرى ("محتوى الاشتراك") ذات صلة بالتسويق عبر الإنترنت منا ومن شركاء خارجيين ("موردو الطرف الثالث"). هذا لا يُعتبر استشارة استثمارية. أنت تفهم وتوافق على أننا لسنا مسؤولين أو ملتزمين بدقة أو اكتمال أو ملاءمة محتوى الاشتراك.', $locale) }}
                </p>
                <p>
                    <i>{{ aiTrans('خدمات المورد والطرف الثالث:', $locale) }}</i> {{ aiTrans('عند ملء نماذج التسجيل، يمكنك الحصول، أو محاولة الحصول، على منتجات و/أو خدمات معينة من الموقع الإلكتروني. قد يتم تقديم أوصاف المنتجات و/أو الخدمات على الموقع الإلكتروني من قبل موردي الطرف الثالث. نحن لا نضمن دقة أو اكتمال هذه الأوصاف. أنت تفهم وتوافق على أننا لسنا مسؤولين أو ملتزمين بعدم قدرتك على الحصول على منتجات و/أو خدمات من الموقع الإلكتروني أو شركائنا التابعين، ولا عن أي نزاعات مع بائعي المنتجات أو الموزعين أو موردي الطرف الثالث الذين قد تتفاعل معهم فيما يتعلق بالموقع الإلكتروني.', $locale) }}
                </p>
                <p>
                    <i>{{ aiTrans('عام:', $locale) }}</i> {{ aiTrans('لاستخدام الخدمات، يجب عليك تقديم بيانات تسجيل دقيقة، ونحتفظ بالحق في رفض البيانات غير المكتملة أو الاحتيالية أو غير المقبولة. ما لم يُنص على خلاف ذلك صراحةً، فإن أي عروض مستقبلية تعزز ميزات الموقع الإلكتروني ستخضع لهذه الشروط. أنت توافق على أننا لسنا مسؤولين عن عدم قدرتك على استخدام و/أو التأهل للخدمات وأي تعديلات أو تعليقات أو إيقاف لها.', $locale) }}
                </p>
                <h3>{{ aiTrans('حقوق الملكية', $locale) }}</h3>
                <p>
                    {{ aiTrans('الموقع الإلكتروني والمحتوى والخدمات، بما في ذلك التنظيم والرسومات والتصميم والبرمجيات ومواد أخرى، محمية بحقوق النشر والعلامات التجارية وحقوق الملكية الأخرى. يُحظر تمامًا إعادة إنتاج أو توزيع أو بيع أي جزء من الموقع الإلكتروني أو المحتوى و/أو الخدمات. يُحظر استرداد المواد عبر وسائل آلية أو "سكرابينغ" لأي غرض دون إذن كتابي. أنت لا تكتسب حقوق ملكية على أي محتوى أو وثيقة أو برمجيات أو خدمات أو مواد على الموقع الإلكتروني. اسمنا وشعارنا ورسوماتنا وأيقوناتنا وأسماء خدماتنا هي علامات تجارية. يُحظر تمامًا الاستخدام غير المصرح به لأي علامة تجارية.', $locale) }}
                </p>
                <h3>{{ aiTrans('المعلومات السرية', $locale) }}</h3>
                <p>
                    {{ aiTrans('تشير المعلومات السرية إلى المعلومات المملوكة التي يتم تحديدها على هذا النحو وتستثني المعلومات المعروفة للعامة أو المعرفة المسبقة أو المعلومات المطورة بشكل مستقل أو المعلومات المستلمة من أطراف ثالثة دون قيود على الإفصاح. تنتهي مسؤولية حماية المعلومات السرية بعد عام واحد من انتهاء العلاقة.', $locale) }}
                </p>
                <h3>{{ aiTrans('حظر الروابط التشعبية للموقع، المشاركة العلامة التجارية، "التأطير" و/أو الإشارة إلى الموقع', $locale) }}</h3>
                <p>
                    {{ aiTrans('يُحظر وضع روابط تشعبية للموقع أو أجزاء منه على موقع آخر دون إذننا الصريح. يُحظر تمامًا "تأطير" الموقع أو الإشارة إلى عنوان URL الخاص به دون إذن كتابي منا. التعاون لإزالة مثل هذا المحتوى أو النشاط إلزامي، وأنت مسؤول عن أي أضرار مرتبطة.', $locale) }}
                </p>
                <h3>{{ aiTrans('التعديل والحذف والتغيير', $locale) }}</h3>
                <p>
                    {{ aiTrans('نحتفظ بالحق في تعديل و/أو حذف أي وثائق أو معلومات أو محتوى على الموقع الإلكتروني دون إشعار مسبق.', $locale) }}
                </p>
                <h3>{{ aiTrans('إخلاء المسؤولية', $locale) }}</h3>
                <p>
                    {{ aiTrans('يتم توفير الموقع الإلكتروني والخدمات والمحتوى وأي منتجات تابعة لأطراف ثالثة "كما هي" و"حسب التوفر"، مع استبعاد جميع الضمانات، الصريحة والضمنية، إلى أقصى حد يسمح به القانون المعمول به. نحن لا نضمن أن الموقع الإلكتروني أو الخدمات أو المحتوى و/أو المنتجات التابعة لأطراف ثالثة ستلبي متطلباتك أو ستكون غير متقطعة أو في الوقت المناسب أو آمنة أو خالية من الأخطاء. أنت توافق على أننا لسنا مسؤولين عن أي مطالبات تتعلق بعدم القدرة على استخدام الموقع الإلكتروني أو الخدمات أو المحتوى و/أو المنتجات التابعة لأطراف ثالثة. قد يحتوي الموقع الإلكتروني على أخطاء أو عيوب أو قيود، ونحن لسنا مسؤولين عن توفر اتصال الإنترنت.', $locale) }}
                </p>
                <h3>{{ aiTrans('تقييد المسؤولية', $locale) }}</h3>
                <p>
                    {{ aiTrans('نحن لسنا مسؤولين عن أي أضرار مباشرة أو غير مباشرة أو عرضية أو خاصة أو تبعية، بما في ذلك فقدان الأرباح أو السمعة أو الاستخدام أو البيانات أو أي خسائر غير ملموسة أخرى. ينطبق هذا التقييد على جميع أسباب الدعوى، بما في ذلك انتهاك العقد أو الضمان أو الإهمال أو المسؤولية المطلقة أو التصريحات الكاذبة وأي جرائم أخرى. أنت تعفينا وموردينا من أطراف ثالثة من أي التزامات أو مسؤوليات أو مطالبات تتجاوز التقييد المذكور. إذا لم يسمح القانون المعمول به بهذا التقييد، فإن الحد الأقصى لمسؤوليتنا في أي ظرف من الظروف سيكون خمسمائة دولار ($500).', $locale) }}
                </p>
                <h3>{{ aiTrans('التعويض', $locale) }}</h3>
                <p>
                    {{ aiTrans('أنت توافق على تعويضنا وإعفائنا وشركائنا وشركاتنا التابعة والجهات التابعة لها وأعضاء مجلس إدارتها وموظفيها ووكلائها وشركائها من أي مطالبات أو نفقات أو أضرار أو إجراءات قضائية أو تكاليف أو مطالب و/أو أحكام صادرة من أطراف ثالثة بسبب أو ناتجة عن استخدامك للموقع الإلكتروني أو الخدمات أو المحتوى؛ انتهاكك لهذه الشروط؛ و/أو انتهاكك لحقوق فرد أو كيان آخر.', $locale) }}
                </p>
                <h3>{{ aiTrans('مواقع أطراف ثالثة', $locale) }}</h3>
                <p>
                    {{ aiTrans('قد يوفر الموقع الإلكتروني روابط لمواقع أخرى و/أو موارد إنترنت مملوكة لموردي أطراف ثالثة. نحن لسنا مسؤولين عن توفر مثل هذه المواقع و/أو موارد أطراف ثالثة، ولا عن محتواها، ولا نؤيد أو نتحمل مسؤولية عن شروطها أو سياسات الخصوصية أو المحتوى أو الإعلانات أو الخدمات أو المنتجات أو المواد.', $locale) }}
                </p>
                <h3>{{ aiTrans('سياسة الخصوصية/معلومات الزوار', $locale) }}</h3>
                <p>
                    {{ aiTrans('يخضع استخدامك للموقع الإلكتروني وجميع التعليقات والملاحظات والمعلومات وبيانات التسجيل و/أو المواد المقدمة لسياسة الخصوصية الخاصة بنا. نحتفظ بالحق في استخدام معلومات حول استخدامك للموقع الإلكتروني والمعلومات الشخصية القابلة للتحديد وفقًا لسياسة الخصوصية الخاصة بنا وقوانين حماية البيانات المعمول بها.', $locale) }}
                </p>
                <h3>{{ aiTrans('إشعار قانوني', $locale) }}</h3>
                <p>
                    {{ aiTrans('أي محاولة لإتلاف أو تدمير أو تزوير أو تخريب أو التدخل في تشغيل الموقع الإلكتروني تعتبر انتهاكًا للقانون الجنائي والمدني. سنسعى لاتخاذ إجراءات ضد أي فرد أو كيان مخالف إلى أقصى حد يسمح به القانون والإنصاف.', $locale) }}
                </p>
                <h3>{{ aiTrans('اختيار القانون والمنتدى', $locale) }}</h3>
                <p>
                    {{ aiTrans('تخضع هذه الشروط وتُفسر وفقًا لقوانين المملكة المتحدة. ستسعى الأطراف للتفاوض بحسن نية للتوصل إلى اتفاق بشأن أي مطالبة أو نزاع ينشأ أو يتعلق بهذه الشروط والأحكام بشكل ودي. إذا لم تتمكن الأطراف من التوصل إلى اتفاق، فسيتم إحالة النزاع حصريًا إلى إجراءات تحكيم سرية أمام محكم واحد في لندن، وفقًا لقواعد غرفة التجارة الدولية (ICC)، ويكون قراره نهائيًا وملزمًا. لا يجوز لأي طرف تقديم مطالبة إلى المحكمة المحلية في مكان إقامته أو أي منتدى آخر.', $locale) }}
                </p>
                <h3>{{ aiTrans('ملحق حماية البيانات', $locale) }}</h3>
                <p>
                    {{ aiTrans('يُعد ملحق حماية البيانات هذا جزءًا من شروطنا وأحكامنا. المصطلحات المستخدمة هنا لها معاني محددة في هذا الملحق. باستثناء ما تم تعديله أدناه، تظل الشروط سارية المفعول بالكامل.', $locale) }}
                </p>
                <ol class="nested-list">
                    <li>
                        <b>{{ aiTrans('تعريفات', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                <b>{{ aiTrans('القوانين المعمول بها:', $locale) }}</b> {{ aiTrans('قوانين الاتحاد الأوروبي أو الدولة العضو المتعلقة بالبيانات الشخصية الخاضعة لقوانين حماية بيانات الاتحاد الأوروبي والقوانين الأخرى المعمول بها للبيانات الشخصية الخاضعة لقوانين حماية بيانات أخرى.', $locale) }}
                            </li>
                            <li>
                                <b>{{ aiTrans('المتحكم:', $locale) }}</b> {{ aiTrans('الكيان الذي يحدد أهداف ووسائل معالجة البيانات الشخصية.', $locale) }}
                            </li>
                            <li>
                                <b>{{ aiTrans('قوانين حماية البيانات:', $locale) }}</b> {{ aiTrans('قوانين حماية بيانات الاتحاد الأوروبي وقوانين حماية البيانات أو الخصوصية لأي دولة أخرى.', $locale) }}
                            </li>
                            <li>
                                <b>{{ aiTrans('قوانين حماية بيانات الاتحاد الأوروبي:', $locale) }}</b> {{ aiTrans('توجيه الاتحاد الأوروبي 95/46/EC، GDPR والقوانين ذات الصلة.', $locale) }}
                            </li>
                            <li>
                                <b>{{ aiTrans('GDPR:', $locale) }}</b> {{ aiTrans('اللائحة العامة لحماية البيانات في الاتحاد الأوروبي 2016/679.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('جمع ومعالجة البيانات الشخصية', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('نحن نتفق على الامتثال لجميع قوانين حماية البيانات المعمول بها في معالجة البيانات الشخصية.', $locale) }}
                                <ol class="nested-list">
                                    <li>
                                        {{ aiTrans('نعلن ونضمن أن لدينا الأذونات والموافقات اللازمة من أصحاب البيانات للسماح قانونًا بجمع ومعالجة ومشاركة البيانات الشخصية عبر الخدمات وفقًا للقوانين المعمول بها.', $locale) }}
                                    </li>
                                    <li>
                                        {{ aiTrans('سنحتفظ بآلية للحصول على الموافقة وسحبها، وفقًا للقوانين المعمول بها، وسياسة خصوصية متاحة للعامة.', $locale) }}
                                    </li>
                                    <li>
                                        {{ aiTrans('نعترف بأننا لا نقدم الخدمات للأطفال الذين تقل أعمارهم عن ثمانية عشر (18) عامًا.', $locale) }}
                                    </li>
                                </ol>
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('الأمان', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('سننفذ إجراءات فنية وتنظيمية مناسبة لأمان البيانات وفقًا للمادة 32(1) من GDPR.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('المعالجة الفرعية', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('أنت تمنحنا الإذن بتعيين معالجين فرعيين وضمان أن العقود المكتوبة مع المعالجين الفرعيين توفر نفس مستوى الحماية للبيانات الشخصية كما هو موضح في هذا الملحق وتلبي متطلبات GDPR.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('حقوق أصحاب البيانات', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('سنقدم المساعدة في الرد على طلبات حقوق أصحاب البيانات وفقًا لقوانين حماية البيانات، مع مراعاة طبيعة المعالجة.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('انتهاك البيانات الشخصية', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('سنخطر أصحاب البيانات المتأثرين على الفور عند علمنا بانتهاك البيانات الشخصية، وسنقدم المساعدة في التحقيق والتخفيف والعلاج.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('شروط عامة', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('تخضع النزاعات أو المطالبات الناشئة عن هذه الشروط للاختصاص القضائي المنصوص عليه هنا. إذا كانت أي بند غير صالح، يظل الباقي ساري المفعول.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('تغييرات', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('يمكن إجراء تغييرات على هذه الشروط من وقت لآخر وفقًا لتقديرنا الحصري.', $locale) }}
                            </li>
                        </ol>
                    </li>
                </ol>
                <p>
                    {{aiTrans('بموافقتك على هذه الشروط والأحكام، فإنك تقر بأنك قد قرأت وفهمت ووافقت على الالتزام بجميع الشروط الموضحة أعلاه. استخدامك المستمر للموقع الإلكتروني والخدمات يشكل قبولك لهذه الشروط. إذا كانت لديك أي أسئلة أو مخاوف، يرجى الاتصال بنا عبر')}} <span >info{{ '@'.$website_title }}</span>
                </p>
                <script>
                    const emails = document.getElementsByClassName('email');
                    for (const email of emails) {
                        email.innerText = `info@${location.hostname}`;
                    }
                </script>
            </div>
        </div>
    </div>
@endsection
