@extends('layouts.app')
@section('title', $website_title .' | O NÁS')
@php( $meta_description = "Objevte, jak ". $website_title." pomáhá rozvíjet vaše investiční dovednosti v oblasti kryptoměn. Nabízíme pokročilé nástroje a úplnou podporu pro dosažení vašich obchodních cílů.")

@section('content')
<div class="what-is w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/what-is-img.webp"  sizes="(max-width: 991px) 100vw, (max-width: 2870px) 50vw, 1435px" alt="{{$website_title}}  - Co přesně je online obchodování?" class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h1 class="about-title">{{aiTrans('O nás')}}</h1>
        <h2 class="about-subtitle">{{aiTrans('Co přesně je online obchodování?')}}</h2>
        <p>{{aiTrans('Online obchodování začalo v roce 1971, kdy byl spuštěn první obchodní software National Association of Securities Dealers Automated Quotations (NASDAQ), jako první online obchodní software. Dnes je online obchodování nejoblíbenější metodou nákupu a prodeje různých finančních aktiv, jako jsou Forex, kryptoměny, akcie, komodity a dokonce i kontrakty na rozdíl (CFD).')}}</p>
        <p>
            
            {{ aiTrans(
                "Na základě toho vznikl [website_title] .",
                $locale,
                ['website_title' => $website_title],
            ) }}</p>
        <p>{{aiTrans('Výkonný a intuitivní obchodní software je schopen využít malé cenové rozdíly mezi různými burzami digitálních měn. Nakupuje kryptoměny za nízkou cenu a poté je prodává za vyšší cenu. Výsledkem jsou malé zisky, které mohou vést k vysokým výnosům pro uživatele.')}}</p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Sledujte video')}}</a>
        </div>
    </div>
    <div class="what-is-bg-1"></div>
</div>

<div class="how-it-working wf-section">
    <div class="container w-container">
        <div class="how-it-working-text">
            
            {{ aiTrans(
                "Kryptoměny jsou vysoce volatilní aktiva a je důležité činit správná rozhodnutí při jejich obchodování. O tom je [website_title] . Výkonná aplikace zajišťuje, že obchodníci s kryptoměnami mají přístup k rychlým a relevantním informacím při obchodování svých oblíbených mincí a tokenů na trhu. Tímto způsobem mohou sledovat nejlepší obchodní příležitosti na kryptoměnových trzích a přijímat přesná a informovaná obchodní rozhodnutí. [website_title] v podstatě zajišťuje, že žádný investor nebude obchodovat naslepo. Aplikace vám umožní obchodovat s jistotou a maximalizovat vaši obchodní aktivitu.",
                $locale,
                ['website_title' => $website_title],
            ) }}</div>
    </div>
</div>

<div class="our-team w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/our-team-img.webp"  sizes="(max-width: 991px) 100vw, 50vw" alt="{{$website_title}}  - Tým {{$website_title}} " class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-team-title">
            {{ aiTrans(
                "Tým [website_title] ",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "Tým [website_title] se skládá z oddaných obchodních profesionálů, kteří chtějí běžným lidem, jako jste vy, poskytnout příležitost efektivně a ziskově obchodovat s Bitcoiny a dalšími kryptoměnami. Tým spojil své znalosti a zkušenosti, aby vytvořil obchodní software, který dokáže rychle a snadno prohledávat různé kryptoměnové burzy a identifikovat ziskové obchodní příležitosti. Celý proces byl automatizován, což umožňuje komukoli obchodovat a získat svůj podíl na tomto lukrativním trhu.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "[website_title] nabízí mnoho výhod a vždy se snažíme přispět pozitivně k vaší obchodní zkušenosti a finanční cestě.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Zaregistrujte se nyní')}}</a>
        </div>
    </div>
</div>
<div class="our-advantage w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/advantage-img.webp"  alt="{{$website_title}}  - Využijte kryptoměnové trhy a vydělávejte s {{$website_title}} " class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-advantage-title">
            {{ aiTrans(
                "Využijte kryptoměnové trhy a vydělávejte s [website_title] ",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "Ve [website_title] chceme, abyste dosáhli finanční svobody, a jak trh s kryptoměnami roste a vyvíjí se, není pochyb o tom, že se objeví více obchodních příležitostí. To jednoduše znamená více zisků pro vás.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "Převezměte kontrolu nad svou budoucností již dnes a zaregistrujte se u [website_title] . Váš úspěch změní váš život. Zaregistrujte si nyní svůj bezplatný účet a zapojte se do obchodování ještě dnes!",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
    </div>
</div>
@endsection
