@extends('layouts.app')
@section('title', $website_title .' | Allgemeine Geschäftsbedingungen')
@php( $meta_description = "Lesen Sie die Allgemeinen Geschäftsbedingungen von ". $website_title.". Unsere Bedingungen erklären Ihre Rechte, Pflichten und wie Sie unsere Dienste sicher und effektiv nutzen können.")

@section('content')
<div class="terms-and-conditions wf-section">
        <div class="w-container">
            <h1>ALLGEMEINE GESCHÄFTSBEDINGUNGEN</h1>
            <div>
                <style>
                    table {
                        width: 100%;
                    }
    
                    table,
                    th,
                    td {
                        border: 1px solid;
                        border-collapse: collapse;
                    }
    
                    th,
                    td {
                        padding: 10px;
                    }
    
                    table td {
                        vertical-align: top;
                    }
    
                    .nested-list {
                        counter-reset: item;
                    }
    
                    .nested-list li {
                        display: block;
                    }
    
                    .nested-list li:before {
                        content: counters(item, '.') '. ';
                        counter-increment: item;
                    }
    
                    .legal-section {
                        text-align: left;
                    }
    
                    .legal-section h3 {
                        margin-top: 30px;
                        font-size: 24px;
                    }
    
                    .legal-section h4 {
                        font-size: 18px;
                    }
                </style>
                <p>
                    {{aiTrans('Danke, dass Sie unsere')}} <a href="{{ route('home', $country) }}"> Website</a> {{aiTrans('besucht haben (die „Website“), auf der Sie den Link zu diesen Allgemeinen Geschäftsbedingungen (den „AGB“) sowie zu unserer')}} <a href="{{ route('privacy', $country) }}">{{aiTrans('Datenschutzrichtlinie')}}</a> {{aiTrans('(die „Datenschutzrichtlinie“) gefunden haben. Diese Website wird betrieben und verwaltet von')}} {{ $website_title }}{{aiTrans(' sowie von deren Muttergesellschaften, Tochtergesellschaften oder verbundenen Unternehmen, die gemeinsam als')}} {{ $website_title }} {{aiTrans('bezeichnet werden. Die Website gehört uns (nachfolgend gemeinsam als „wir“, „unser“ oder „uns“ bezeichnet) und Sie können uns jederzeit per E-Mail kontaktieren')}}
                    unter: <span >info{{ '@'.$website_title }}</span>
                </p>
                <p>
                    {{ aiTrans('Durch den Zugriff auf die Website oder die Nutzung unserer Produkte und/oder Dienstleistungen ("Anbieterdienste" und zusammen mit den Abonnementdiensten als "Dienste" bezeichnet) erklären Sie sich damit einverstanden, diese Nutzungsbedingungen ("Bedingungen") sowie unsere Datenschutzrichtlinie einzuhalten. Diese Bedingungen umfassen betriebliche Regeln, Richtlinien, Informationen und andere ergänzende Bedingungen. Wir behalten uns das Recht vor, die Bedingungen von Zeit zu Zeit ohne vorherige Ankündigung nach eigenem Ermessen zu ändern. Es liegt in Ihrer Verantwortung, diese Seite regelmäßig auf Aktualisierungen der Bedingungen zu überprüfen, die nach der Veröffentlichung in Kraft treten. Ihre fortgesetzte Nutzung der Website gilt als Zustimmung zu den Bedingungen.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Bitte lesen Sie die vollständigen Bedingungen dieser Allgemeinen Geschäftsbedingungen sorgfältig durch. Wenn Sie mit irgendeinem Teil nicht einverstanden sind, sind Sie nicht berechtigt, die Dienste oder die Website in irgendeiner Weise zu nutzen. Wir behalten uns das Recht vor, den Zugriff auf die Dienste und/oder die Website nach eigenem Ermessen zu verweigern.', $locale) }}
                </p>
                <h3>{{ aiTrans('KEINE ANLAGEBERATUNG', $locale) }}</h3>
                <p>
                    {{ aiTrans('Sofern nicht ausdrücklich anders angegeben, ist diese Website nicht dazu bestimmt, persönliche Finanz- oder Anlageberatung bereitzustellen. Die bereitgestellten Informationen berücksichtigen nicht Ihre spezifischen Anlageziele, Ihre finanzielle Situation oder Ihre Anlagebedürfnisse.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Sie sollten selbst bewerten, ob die Informationen auf dieser Website für Ihre Anlageziele, Ihre finanzielle Situation und Ihre Anlagebedürfnisse geeignet sind. Dies sollten Sie tun, bevor Sie eine Anlageentscheidung auf der Grundlage der auf dieser Website bereitgestellten Informationen treffen. Sie können diese Bewertung selbst vornehmen oder sich von einem unabhängigen Finanzberater professionell beraten lassen.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Sofern nicht ausdrücklich anders angegeben, stellen die auf dieser Website enthaltenen Informationen keine Empfehlung zur Investition in Finanzprodukte oder -dienstleistungen dar, die von einem Mitglied der IG-Unternehmensgruppe angeboten werden.', $locale) }}
                </p>
                <h3>{{ aiTrans('PRODUKTE UND DIENSTLEISTUNGEN', $locale) }}</h3>
                <p>
                    {{ aiTrans('Nicht alle auf dieser Website erwähnten Produkte und Dienstleistungen werden unbedingt von uns bereitgestellt. Die Identifizierung oder Nutzung von Produkten, Dienstleistungen, Websites oder Netzwerken Dritter stellt keine Empfehlung dieser Produkte, Dienstleistungen, Websites oder Netzwerke dar. Diese Website kann Ihnen den Zugriff auf Websites und Netzwerke ermöglichen, die von anderen Personen als uns über einen Hyperlink oder eine andere Verbindung bereitgestellt werden.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Wir übernehmen keine Haftung oder Verantwortung für Materialien auf einer Website oder einem Netzwerk, das nicht unter unserer direkten Kontrolle steht. Sie erkennen an, dass Ihr Zugriff auf diese anderen Websites oder Netzwerke über einen solchen Link dazu führen kann, dass wir bestimmte Informationen über Sie an den Eigentümer dieser Website oder dieses Netzwerks weitergeben müssen. Nichts auf dieser Website soll als Anlage- oder Finanzberatung von uns verstanden werden.', $locale) }}
                </p>
                <h3>{{ aiTrans('UMFANG UND ÄNDERUNG', $locale) }}</h3>
                <p>
                    {{ aiTrans('Sie stimmen den in diesem Dokument beschriebenen Bedingungen in Bezug auf die Nutzung unserer Website zu. Diese Bedingungen stellen die vollständige Vereinbarung zwischen Ihnen und uns dar und ersetzen alle vorherigen Vereinbarungen, Erklärungen, Garantien und Absprachen in Bezug auf die Website.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Bitte beachten Sie, dass diese Bedingungen von Zeit zu Zeit geändert werden können. Falls wir diese Bedingungen ändern, werden wir Sie über die verfügbaren Optionen in Bezug auf solche Änderungen informieren. Außerdem werden wir eine Mitteilung über die Änderung veröffentlichen. Die fortgesetzte Nutzung der Website und/oder unserer Dienste bedeutet Ihre uneingeschränkte Zustimmung zur Einhaltung der zu diesem Zeitpunkt geltenden aktualisierten Bedingungen. Es liegt in Ihrer Verantwortung, diese Seite regelmäßig auf Aktualisierungen und/oder Änderungen zu überprüfen.', $locale) }}
                </p>
                <h3>{{ aiTrans('VORAUSSETZUNGEN', $locale) }}</h3>




                <p>
                    {{ aiTrans('Die Website und unsere Dienste stehen ausschließlich Personen zur Verfügung, die rechtsverbindliche Verträge gemäß den geltenden Gesetzen abschließen können. Sie sind nicht für die Nutzung durch Personen unter achtzehn (18) Jahren bestimmt. Wenn Sie unter achtzehn (18) Jahre alt sind, ist es Ihnen nicht gestattet, die Website und/oder die Dienste zu nutzen oder darauf zuzugreifen.', $locale) }}
                </p>
                <h3>{{ aiTrans('BESCHREIBUNG DER DIENSTE', $locale) }}</h3>
                <p>
                    <i>{{ aiTrans('Abonnementdienste:', $locale) }}</i> {{ aiTrans('Durch die Registrierung auf der Website und unsere Genehmigung können Sie kostenpflichtige oder kostenlose Abonnementdienste erhalten oder versuchen, diese zu erhalten. Diese Dienste bieten E-Mail-Inhalte, Text und andere Materialien ("Abonnementinhalte"), die für das Online-Marketing von uns und Drittanbietern ("Drittanbieter") relevant sind. Dies stellt keine Anlageberatung dar. Sie verstehen und stimmen zu, dass wir nicht für die Richtigkeit, Vollständigkeit oder Eignung der Abonnementinhalte verantwortlich oder haftbar sind.', $locale) }}
                </p>
                <p>
                    <i>{{ aiTrans('Lieferanten- und Drittanbieterdienste:', $locale) }}</i> {{ aiTrans('Durch das Ausfüllen von Registrierungsformularen können Sie bestimmte Produkte und/oder Dienstleistungen von der Website erhalten oder versuchen, diese zu erhalten. Produkt- und/oder Dienstleistungsbeschreibungen auf der Website können von Drittanbietern bereitgestellt werden. Wir garantieren nicht die Richtigkeit oder Vollständigkeit solcher Beschreibungen. Sie verstehen und stimmen zu, dass wir nicht für Ihre Unfähigkeit verantwortlich oder haftbar sind, Produkte und/oder Dienstleistungen von der Website oder ihren verbundenen Partnern zu erhalten, noch für Streitigkeiten mit Produktverkäufern, Vertriebspartnern oder Drittanbietern, mit denen Sie im Zusammenhang mit der Website interagieren können.', $locale) }}
                </p>
                <p>
                    <i>{{ aiTrans('Allgemeines:', $locale) }}</i> {{ aiTrans('Um die Dienste zu nutzen, müssen Sie genaue Registrierungsdaten angeben. Wir behalten uns das Recht vor, unvollständige, betrügerische oder inakzeptable Daten abzulehnen. Sofern nicht ausdrücklich anders angegeben, unterliegen zukünftige Angebote, die die Funktionalität der Website verbessern, diesen Bedingungen. Sie stimmen zu, dass wir nicht für Ihre Unfähigkeit verantwortlich sind, die Dienste zu nutzen oder sich dafür zu qualifizieren, sowie für alle Änderungen, Aussetzungen oder Einstellungen.', $locale) }}
                </p>
                <h3>{{ aiTrans('EIGENTUMSRECHTE', $locale) }}</h3>
                <p>
                    {{ aiTrans('Die Website, die Inhalte und die Dienste, einschließlich Organisation, Grafiken, Design, Zusammenstellung, Software und andere Aspekte, sind durch Urheberrechte, Marken und andere anwendbare Eigentumsrechte geschützt. Die Reproduktion, Weiterverteilung oder der Verkauf eines Teils der Website, Inhalte und/oder Dienste ist strengstens untersagt. Das Abrufen von Materialien durch automatisierte Mittel oder Scraping für jegliche Zwecke ohne schriftliche Genehmigung ist verboten. Sie erwerben keine Eigentumsrechte an Inhalten, Dokumenten, Software, Diensten oder Materialien auf der Website. Unser Name, Logo, Grafiken, Symbole und Servicenamen sind eingetragene Marken. Die unbefugte Nutzung einer Marke ist strengstens untersagt.', $locale) }}
                </p>
                <h3>{{ aiTrans('VERTRAULICHE INFORMATIONEN', $locale) }}</h3>
                <p>
                    {{ aiTrans('Vertrauliche Informationen beziehen sich auf geschützte Informationen, die als solche gekennzeichnet sind, und schließen öffentlich bekannte Informationen, vorheriges Wissen, unabhängig entwickelte Informationen oder von Dritten erhaltene Informationen ohne Offenlegungsbeschränkungen aus. Die Verpflichtung zum Schutz vertraulicher Informationen erlischt ein (1) Jahr nach Beendigung.', $locale) }}
                </p>
                <h3>{{ aiTrans('VERBOT VON HYPERLINKS ZUR WEBSITE, CO-BRANDING, "FRAMING" UND/ODER VERWEISUNG AUF DIE WEBSITE', $locale) }}</h3>
                <p>
                    {{ aiTrans('Hyperlinks zur Website oder Teilen davon auf einer anderen Website ohne unsere ausdrückliche Genehmigung sind verboten. Das "Framing" der Website oder die Bezugnahme auf die Uniform Resource Locator ("URL") ohne unsere schriftliche Genehmigung ist strengstens untersagt. Die Zusammenarbeit zur Entfernung solcher Inhalte oder Aktivitäten ist obligatorisch, und Sie haften für alle damit verbundenen Schäden.', $locale) }}
                </p>
                <h3>{{ aiTrans('BEARBEITUNG, LÖSCHUNG UND ÄNDERUNG', $locale) }}</h3>
                <p>
                    {{ aiTrans('Wir behalten uns das Recht vor, Dokumente, Informationen oder Inhalte auf der Website ohne vorherige Ankündigung zu bearbeiten und/oder zu löschen.', $locale) }}
                </p>
                <h3>{{ aiTrans('HAFTUNGSAUSSCHLUSS', $locale) }}</h3>
                <p>
                    {{ aiTrans('DIE WEBSITE, DIENSTE, INHALTE UND ALLE PRODUKTE DRITTER WERDEN "WIE BESEHEN" UND "WIE VERFÜGBAR" BEREITGESTELLT, WOBEI ALLE AUSDRÜCKLICHEN UND IMPLIZITEN GARANTIEN IM MAXIMAL ZULÄSSIGEN UMFANG DES GELTENDEN RECHTS AUSGESCHLOSSEN SIND. WIR GARANTIEREN NICHT, DASS DIE WEBSITE, DIENSTE, INHALTE UND/ODER DRITTANBIETERPRODUKTE IHREN ANFORDERUNGEN ENTSPRECHEN ODER UNUNTERBROCHEN, PÜNKTLICH, SICHER ODER FEHLERFREI SIND. SIE STIMMEN ZU, DASS WIR NICHT FÜR ANSPRÜCHE IM ZUSAMMENHANG MIT IHRER UNFÄHIGKEIT, DIE WEBSITE, DIENSTE, INHALTE UND/ODER DRITTANBIETERPRODUKTE ZU NUTZEN, VERANTWORTLICH SIND. DIE WEBSITE KANN FEHLER, BUGS ODER EINSCHRÄNKUNGEN ENTHALTEN, UND WIR SIND NICHT FÜR DIE VERFÜGBARKEIT DER INTERNETVERBINDUNG VERANTWORTLICH.', $locale) }}
                </p>
                <h3>{{ aiTrans('HAFTUNGSBESCHRÄNKUNG', $locale) }}</h3>






                <p>
                    {{ aiTrans('WIR HAFTEN NICHT FÜR DIREKTE, INDIREKTE, ZUFÄLLIGE, BESONDERE ODER EXEMPLARISCHE SCHÄDEN, EINSCHLIESSLICH ENTGANGENEM GEWINN, GOODWILL, NUTZUNG, DATEN ODER ANDEREN IMMATERIELLEN VERLUSTEN. DIESE BESCHRÄNKUNG GILT FÜR ALLE KLAGEGRÜNDE, EINSCHLIESSLICH VERTRAGSBRUCH, GARANTIE, FAHRLÄSSIGKEIT, STRIKTE HAFTUNG, FALSCHAUSSAGEN UND ANDERE DELIKTE. SIE STELLEN UNS UND UNSERE DRITTANBIETER VON JEGLICHER HAFTUNG ODER ANSPRÜCHEN ÜBER DIE ANGEGEBENE BESCHRÄNKUNG HINAUS FREI. WENN DAS ANWENDBARE RECHT DIESE BESCHRÄNKUNG NICHT ERLAUBT, BETRÄGT UNSERE MAXIMALE HAFTUNG UNTER ALLEN UMSTÄNDEN FÜNFHUNDERT DOLLAR ($500,00).', $locale) }}
                </p>
                <h3>{{ aiTrans('ENTSCHÄDIGUNG', $locale) }}</h3>
                <p>
                    {{ aiTrans('Sie erklären sich damit einverstanden, uns, unsere Partner, Tochtergesellschaften, verbundenen Unternehmen und deren jeweilige Mitglieder, Direktoren, Mitarbeiter, Vertreter und Partner von jeglichen Ansprüchen, Kosten, Schäden, Klagen, Forderungen und/oder Urteilen Dritter freizustellen, die aufgrund Ihrer Nutzung der Website, der Dienste oder Inhalte; Ihrer Verletzung dieser Bedingungen; und/oder Ihrer Verletzung der Rechte einer anderen Person und/oder juristischen Person entstehen oder daraus resultieren.', $locale) }}
                </p>
                <h3>{{ aiTrans('WEBSITES DRITTER', $locale) }}</h3>
                <p>
                    {{ aiTrans('Die Website kann Links zu anderen Websites und/oder Internetressourcen enthalten, die Drittanbietern gehören. Wir sind nicht für die Verfügbarkeit solcher Websites und/oder Ressourcen Dritter verantwortlich, noch für deren Inhalte. Wir unterstützen oder übernehmen keine Verantwortung für deren Nutzungsbedingungen, Datenschutzrichtlinien, Inhalte, Werbung, Dienstleistungen, Produkte oder Materialien.', $locale) }}
                </p>
                <h3>{{ aiTrans('DATENSCHUTZRICHTLINIE / BESUCHERINFORMATIONEN', $locale) }}</h3>
                <p>
                    {{ aiTrans('Ihre Nutzung der Website und alle Kommentare, Rückmeldungen, Registrierungsdaten und/oder übermittelten Materialien unterliegen unserer Datenschutzrichtlinie. Wir behalten uns das Recht vor, Informationen über Ihre Nutzung der Website und personenbezogene Informationen gemäß unserer Datenschutzrichtlinie und den geltenden Datenschutzgesetzen zu verwenden.', $locale) }}
                </p>
                <h3>{{ aiTrans('RECHTLICHER HINWEIS', $locale) }}</h3>
                <p>
                    {{ aiTrans('Jeder Versuch, die Website zu beschädigen, zu zerstören, zu manipulieren, zu sabotieren oder ihren Betrieb zu stören, stellt eine Verletzung von Straf- und Zivilrecht dar. Wir werden gegen jede Person oder juristische Person, die gegen diese Vorschriften verstößt, rechtliche Schritte mit der vollen Härte des Gesetzes und im größtmöglichen Umfang ergreifen.', $locale) }}
                </p>
                <h3>{{ aiTrans('GELTENDES RECHT UND GERICHTSSTAND', $locale) }}</h3>
                <p>
                    {{ aiTrans('Diese Bedingungen unterliegen den Gesetzen des Vereinigten Königreichs und sind entsprechend auszulegen. Die Parteien werden versuchen, alle Streitigkeiten oder Ansprüche, die sich aus oder im Zusammenhang mit diesen Nutzungsbedingungen ergeben, in gutem Glauben gütlich beizulegen. Sollte eine Einigung nicht erzielt werden, wird die Streitigkeit ausschließlich durch ein vertrauliches Schiedsverfahren vor einem Einzelschiedsrichter in London gemäß den Regeln der ICC geregelt, dessen Schiedsspruch endgültig und bindend ist. Keine Partei darf eine Klage vor einem lokalen Gericht ihres Wohnsitzes oder einer anderen Gerichtsbarkeit einreichen.', $locale) }}
                </p>
                <h3>{{ aiTrans('DATENSCHUTZANHANG', $locale) }}</h3>
                <p>
                    {{ aiTrans('Dieser Datenschutzanhang ist Bestandteil unserer Nutzungsbedingungen. Die hierin verwendeten Begriffe haben die in diesem Anhang festgelegte Bedeutung. Sofern nicht anders angegeben, bleiben die Bedingungen in vollem Umfang gültig und wirksam.', $locale) }}
                </p>
                <ol class="nested-list">
                    <li>
                        <b>{{ aiTrans('Definitionen', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                <b>{{ aiTrans('Anwendbare Gesetze:', $locale) }}</b> {{ aiTrans('Gesetze der EU oder der Mitgliedstaaten zum Schutz personenbezogener Daten, die den EU-Datenschutzgesetzen und anderen anwendbaren Datenschutzgesetzen unterliegen.', $locale) }}
                            </li>
                            <li>
                                <b>{{ aiTrans('Verantwortlicher:', $locale) }}</b> {{ aiTrans('Die juristische Person, die die Zwecke und Mittel der Verarbeitung personenbezogener Daten bestimmt.', $locale) }}
                            </li>
                            <li>
                                <b>{{ aiTrans('Datenschutzgesetze:', $locale) }}</b> {{ aiTrans('Gesetze zum Schutz personenbezogener Daten in der EU und Datenschutz- oder Privatsphäre-Gesetze in anderen Ländern.', $locale) }}
                            </li>
                            <li>
                                <b>{{ aiTrans('EU-Datenschutzgesetze:', $locale) }}</b> {{ aiTrans('Richtlinie 95/46/EG der EU, DSGVO und verwandte Gesetze.', $locale) }}
                            </li>
                            <li>
                                <b>{{ aiTrans('DSGVO:', $locale) }}</b> {{ aiTrans('EU-Datenschutz-Grundverordnung 2016/679.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('Erhebung und Verarbeitung personenbezogener Daten', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('Wir verpflichten uns, alle anwendbaren Datenschutzgesetze bei der Verarbeitung personenbezogener Daten einzuhalten.', $locale) }}
                                <ol class="nested-list">
                                    <li>
                                        {{ aiTrans('Wir erklären und gewährleisten, dass wir die erforderlichen Genehmigungen und Einwilligungen von betroffenen Personen haben, um personenbezogene Daten im Rahmen der Dienstleistungen gemäß den anwendbaren Gesetzen zu erfassen, zu verarbeiten und weiterzugeben.', $locale) }}
                                    </li>
                                    <li>
                                        {{ aiTrans('Wir werden Mechanismen zur Einholung und zum Widerruf der Einwilligung gemäß den anwendbaren Gesetzen unterhalten und eine öffentlich zugängliche Datenschutzrichtlinie bereitstellen.', $locale) }}
                                    </li>
                                    <li>
                                        {{ aiTrans('Wir erkennen an, dass wir keine Dienstleistungen für Kinder unter achtzehn (18) Jahren erbringen.', $locale) }}
                                    </li>
                                </ol>
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('Sicherheit', $locale) }}</b>
                    </li>
                </ol>


                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('Wir werden angemessene technische und organisatorische Maßnahmen zum Schutz von Daten gemäß Artikel 32(1) der DSGVO implementieren.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('Unterauftragsverarbeitung', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('Sie ermächtigen uns, Unterauftragsverarbeiter zu benennen und sicherzustellen, dass schriftliche Vereinbarungen mit Unterauftragsverarbeitern das gleiche Schutzniveau für personenbezogene Daten bieten, wie in diesem Anhang beschrieben, und die Anforderungen der DSGVO erfüllen.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('Rechte der betroffenen Personen', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('Wir werden dabei helfen, Anfragen von betroffenen Personen gemäß den Datenschutzgesetzen zu beantworten, wobei die Art der Verarbeitung berücksichtigt wird.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('Verletzung personenbezogener Daten', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('Wir werden betroffene Personen unverzüglich benachrichtigen, sobald wir von einer Verletzung personenbezogener Daten Kenntnis erlangen, und Unterstützung bei der Untersuchung, Minderung und Behebung leisten.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('Allgemeine Bestimmungen', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('Streitigkeiten oder Ansprüche, die sich aus diesen Bedingungen ergeben, unterliegen der hierin festgelegten Gerichtsbarkeit. Sollte eine Bestimmung ungültig sein, bleibt der übrige Teil in vollem Umfang gültig.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('Änderungen', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('Änderungen dieser Bedingungen können von Zeit zu Zeit nach unserem alleinigen Ermessen vorgenommen werden.', $locale) }}
                            </li>
                        </ol>
                    </li>
                </ol>
                <p>
                    {{aiTrans('Durch die Zustimmung zu diesen Allgemeinen Geschäftsbedingungen bestätigen Sie, dass Sie alle oben beschriebenen Bedingungen gelesen, verstanden und akzeptiert haben. Ihre fortgesetzte Nutzung der Website und der Dienste stellt Ihre Zustimmung zu diesen Bedingungen dar. Wenn Sie Fragen oder Bedenken haben, kontaktieren Sie uns bitte unter')}} <span >info{{ '@'.$website_title }}</span>
                </p>
                <script>
                    const emails = document.getElementsByClassName('email');
                    for (const email of emails) {
                        email.innerText = `info@${location.hostname}`;
                    }
                </script>



            </div>
        </div>
    </div>
@endsection
