@extends('layouts.app')
@section('title', $website_title .' | CONTÁCTANOS')
@php( $meta_description = "¡Ponte en contacto con el equipo de ". $website_title."! Estamos aquí para responder tus preguntas y ofrecer soporte en tu experiencia de trading de criptomonedas.")

@section('content')
<div class="contact w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/contact-img.webp" sizes="(max-width: 991px) 100vw, 50vw"  alt="{{ $website_title }} - Contáctanos" class="img-float-right max-width-50-percent contact-image">
    <div class="container w-container">
        <h1>{{aiTrans('Contáctanos')}}</h1>
        <div class="contact-form-warp">
            <div class="w-form-wrapper">
                <form data-name="" action="" method="post" id="email-form" name="email-form" class="contact-form" data-wf-page-id="62f100d8551494f3d8716116" data-wf-element-id="5b923abc-fcd6-8970-5604-5bab15c5eede" novalidate="novalidate">
                    <div class="contact-cell">
                        <div class="email-and-name w-row">
                            <div class="name-col w-col w-col-6">
                                <div class="form-group">
                                    <input type="text" class="form-control control-bordered w-input" maxlength="256" name="FunnelContactForm[name]" data-name="FunnelContactForm[name]" placeholder="Introduce el nombre">
                                    <div class="warning-icon"></div>
                                </div>
                            </div>
                            <div class="email-col w-col w-col-6">
                                <div class="form-group">
                                    <input type="email" class="form-control control-bordered w-input" maxlength="256" name="FunnelContactForm[email]" data-name="FunnelContactForm[email]" placeholder="Introduce la dirección de correo electrónico">
                                    <div class="warning-icon"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="contact-cell">
                        <div class="form-group">
                            <textarea placeholder="Escribe el mensaje..." maxlength="5000" data-name="FunnelContactForm[message]" name="FunnelContactForm[message]" id="field" class="form-control textarea w-input"></textarea>
                            <div class="warning-icon"></div>
                        </div>
                    </div>
                    <div class="text-center-2"><button type="submit" data-wait="Por favor espera ..." class="button w-button">Enviar mensaje</button></div>
                </form>
                <div class="w-form-done">
                    <div>{{aiTrans('¡Gracias! Tu envío ha sido recibido!')}}</div>
                </div>
                <div class="w-form-fail">
                    <div>{{aiTrans('¡Vaya! Algo salió mal al enviar el formulario.')}}</div>
                </div>
            </div>
        </div>
    </div>
    <div class="contact-bg-1"></div>
</div>
    @push('css')
        <style>
            /* Estilo personalizado para el mensaje de éxito */
            .success-message {
                background-color: #d4edda;
                color: #155724;
                padding: 15px;
                border: 1px solid #c3e6cb;
                border-radius: 5px;
                margin-bottom: 20px;
            }

            /* Ocultar el mensaje por defecto */
            .d-none {
                display: none;
            }

            /* Estilo personalizado para el botón */
            .btn-submit {
                background-color: #28a745; /* Color verde personalizado */
                color: white;
                padding: 10px 20px;
                border: none;
                border-radius: 5px;
                cursor: pointer;
                font-size: 18px;
            }

            .btn-submit:hover {
                background-color: #218838; /* Verde más oscuro al pasar el cursor */
            }

            /* Estilo básico del formulario */
            .form-group input, .form-group textarea {
                width: 100%;
                padding: 10px;
                border: 1px solid #ccc;
                border-radius: 5px;
            }

        </style>
    @endpush
    @push('js')
        <script>
            document.getElementById('contactForm').addEventListener('submit', function(event) {
                event.preventDefault(); // Prevenir el envío tradicional del formulario

                // Simular el envío del formulario
                setTimeout(function() {
                    // Mostrar el mensaje de éxito
                    document.getElementById('successMessage').classList.remove('d-none');

                    // Opcionalmente, limpiar los campos del formulario
                    document.getElementById('contactForm').reset();
                }, 500); // Simular retraso en la respuesta del servidor
            });
        </script>
    @endpush
@endsection
