@extends('layouts.app')
@section('title', $website_title .' | Términos y Condiciones')
@php( $meta_description = "Lea los términos y condiciones de ". $website_title.". Nuestros términos explican sus derechos, responsabilidades y cómo usar nuestros servicios de forma segura y eficaz.")

@section('content')
<div class="terms-and-conditions wf-section">
        <div class="w-container">
            <h1>TÉRMINOS Y CONDICIONES</h1>
            <div>
                <style>
                    table {
                        width: 100%;
                    }
    
                    table,
                    th,
                    td {
                        border: 1px solid;
                        border-collapse: collapse;
                    }
    
                    th,
                    td {
                        padding: 10px;
                    }
    
                    table td {
                        vertical-align: top;
                    }
    
                    .nested-list {
                        counter-reset: item;
                    }
    
                    .nested-list li {
                        display: block;
                    }
    
                    .nested-list li:before {
                        content: counters(item, '.') '. ';
                        counter-increment: item;
                    }
    
                    .legal-section {
                        text-align: left;
                    }
    
                    .legal-section h3 {
                        margin-top: 30px;
                        font-size: 24px;
                    }
    
                    .legal-section h4 {
                        font-size: 18px;
                    }
                </style>
                <p>
                    {{aiTrans('Gracias por visitar nuestro')}} <a href="{{ route('home', $country) }}"> sitio web</a> {{aiTrans('(el "Sitio Web") donde encontró el enlace a estos Términos y Condiciones (el "Sitio Web"), y nuestra')}} <a href="{{ route('privacy', $country) }}">{{aiTrans('Política de Privacidad')}}</a> {{aiTrans('(la "Política de Privacidad"). Este sitio web es operado y controlado por')}} {{ $website_title }}{{aiTrans(' y cualquier empresa matriz, subsidiarias o entidades relacionadas, todas referidas como')}} {{ $website_title }}. {{aiTrans('El Sitio Web es de nuestra propiedad
                    (referido colectivamente como "nosotros", "nuestro" o "nos") y puede contactarnos en cualquier momento por correo electrónico a')}}
                    para: <span >info{{ '@'.$website_title }}</span>
                </p>
                <p>
                    {{ aiTrans('Al acceder al Sitio Web o utilizar nuestros productos y/o servicios ("Servicios del Proveedor" y colectivamente con los Servicios de Suscripción, referidos como "Servicios"), usted acepta cumplir con estos Términos de Uso ("Términos") y nuestra Política de Privacidad. Estos Términos incluyen reglas operativas, políticas, información y otros términos suplementarios. Nos reservamos el derecho de modificar los Términos de vez en cuando sin previo aviso y a nuestra discreción. Es su responsabilidad revisar periódicamente esta página para actualizaciones de los Términos, que entrarán en vigor después de la publicación. Su uso continuo del Sitio Web será considerado como aceptación de los Términos.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Por favor, revise cuidadosamente los términos completos de estos Términos y Condiciones. Si no está de acuerdo con alguna parte de ellos, no tiene autorización para utilizar los Servicios ni el Sitio Web de ninguna manera. Nos reservamos el derecho de negar el acceso a los Servicios y/o al Sitio Web a nuestra exclusiva discreción.', $locale) }}
                </p>
                <h3>{{ aiTrans('SIN ASESORÍA DE INVERSIONES', $locale) }}</h3>
                <p>
                    {{ aiTrans('A menos que se indique expresamente lo contrario, este sitio web no ha sido diseñado con el objetivo de proporcionar asesoramiento financiero o de inversión personal. La información proporcionada no tiene en cuenta sus objetivos de inversión específicos, su situación financiera o sus necesidades de inversión.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Debe evaluar si la información de este sitio web es adecuada para sus objetivos de inversión, situación financiera y necesidades de inversión. Debe hacer esto antes de tomar una decisión de inversión basada en la información proporcionada en este sitio web. Puede hacer esta evaluación por su cuenta o buscar la asistencia profesional de un asesor financiero independiente.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('A menos que se indique expresamente lo contrario, la información contenida en este sitio web no constituye una recomendación de inversión en ningún producto o servicio financiero ofrecido por cualquier miembro del grupo de empresas IG.', $locale) }}
                </p>
                <h3>{{ aiTrans('PRODUCTOS Y SERVICIOS', $locale) }}</h3>
                <p>
                    {{ aiTrans('No todos los productos y servicios mencionados en este sitio web son necesariamente proporcionados por nosotros. La identificación o el uso de productos, servicios, sitios web o redes de terceros no constituye una recomendación de esos productos, servicios, sitios web o redes. Este sitio web puede permitirle acceder a sitios web y redes proporcionadas por personas que no somos nosotros a través de un hipervínculo u otro enlace.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('No aceptamos ninguna responsabilidad o obligación de ningún tipo con respecto a cualquier material en cualquier sitio web o red que no esté bajo nuestro control directo. Usted reconoce que su acceso a esos otros sitios web o redes a través de dicho enlace puede obligarnos a proporcionar cierta información sobre usted al propietario de ese sitio web o red. Nada en este sitio web tiene la intención de ser, ni debe ser entendido por usted como siendo, asesoramiento de inversión o financiero nuestro o por nosotros.', $locale) }}
                </p>
                <h3>{{ aiTrans('ÁMBITO Y MODIFICACIÓN', $locale) }}</h3>
                <p>
                    {{ aiTrans('Usted acepta los términos descritos en este documento en relación con el uso de nuestro Sitio Web. Estos Términos constituyen el acuerdo completo entre usted y nosotros, reemplazando todos los acuerdos, representaciones, garantías y entendimientos anteriores relacionados con el Sitio Web.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Tenga en cuenta que estos Términos pueden modificarse periódicamente. Si modificamos estos Términos, le informaremos sobre las opciones disponibles en virtud de dichos cambios. Además, publicaremos un aviso indicando la modificación. El uso continuo del Sitio Web y/o de nuestros Servicios implica su total acuerdo en cumplir con los términos y condiciones actualizados vigentes en ese momento. Es su responsabilidad revisar regularmente esta página para actualizaciones y/o cambios.', $locale) }}
                </p>
                <h3>{{ aiTrans('REQUISITOS', $locale) }}</h3>
                <p>
                    {{ aiTrans('El Sitio Web y nuestros Servicios están disponibles exclusivamente para individuos elegibles para celebrar contratos legalmente vinculantes de acuerdo con la legislación aplicable. No están destinados para el uso por individuos menores de dieciocho (18) años. Si tiene menos de dieciocho (18) años, no tiene permiso para usar y/o acceder al Sitio Web y/o los Servicios.', $locale) }}
                </p>
                <h3>{{ aiTrans('DESCRIPCIÓN DE LOS SERVICIOS', $locale) }}</h3>
                <p>
                    <i>{{ aiTrans('Servicios de Suscripción:', $locale) }}</i> {{ aiTrans('Al registrarse en el Sitio Web y recibir nuestra aprobación, puede obtener, o intentar obtener, Servicios de Suscripción por una tarifa o sin tarifa. Estos servicios proporcionan contenido de correo electrónico, texto y otros materiales ("Contenido de Suscripción") relevantes para marketing en línea de nosotros y de socios terceros ("Proveedores Externos"). Esto no es asesoramiento de inversión. Usted entiende y acepta que no somos responsables por la precisión, completitud o idoneidad del Contenido de Suscripción.', $locale) }}
                </p>
                <p>
                    <i>{{ aiTrans('Servicios de Proveedor y Terceros:', $locale) }}</i> {{ aiTrans('Al completar formularios de registro, puede obtener, o intentar obtener, ciertos productos y/o servicios del Sitio Web. Las descripciones de productos y/o servicios en el Sitio Web pueden ser proporcionadas por Proveedores Externos. No garantizamos la precisión o completitud de tales descripciones. Usted entiende y acepta que no somos responsables por su incapacidad de obtener productos y/o servicios del Sitio Web o de sus socios afiliados, ni por cualquier disputa con vendedores de productos, distribuidores, proveedores externos con los que pueda interactuar en relación al sitio web.', $locale) }}
                </p>
                <p>
                    <i>{{ aiTrans('General:', $locale) }}</i> {{ aiTrans('Para usar los Servicios, debe proporcionar datos de Registro de Servicio precisos, y nos reservamos el derecho de rechazar datos incompletos, fraudulentos o inaceptables. A menos que se indique expresamente lo contrario, cualquier oferta futura que mejore las características del Sitio Web estará sujeta a estos Términos. Usted acepta que no somos responsables por su incapacidad de usar y/o calificar para los Servicios y cualquier modificación, suspensión o discontinuación.', $locale) }}
                </p>
                <h3>{{ aiTrans('DERECHOS DE PROPIEDAD', $locale) }}</h3>


<p>
    {{ aiTrans('El Sitio Web, el Contenido y los Servicios, incluyendo la organización, gráficos, diseño, compilación, software y otros asuntos, están protegidos por derechos de autor, marcas registradas y otros derechos de propiedad aplicables. La reproducción, redistribución o venta de cualquier parte del Sitio Web, Contenido y/o Servicios está estrictamente prohibida. La recuperación de material mediante medios automatizados o scraping para cualquier finalidad sin permiso por escrito está prohibida. No adquiere derechos de propiedad sobre ningún contenido, documento, software, servicios o materiales en el Sitio Web. Nuestro nombre, logotipo, gráficos, íconos y nombres de servicios son marcas registradas. El uso no autorizado de cualquier marca registrada está estrictamente prohibido.', $locale) }}
</p>
<h3>{{ aiTrans('INFORMACIÓN CONFIDENCIAL', $locale) }}</h3>
<p>
    {{ aiTrans('La información confidencial se refiere a la información propietaria identificada como tal y excluye información conocida públicamente, conocimiento previo, información desarrollada independientemente o información recibida de terceros sin restricciones de divulgación. La obligación de proteger la información confidencial expira un (1) año después de la finalización.', $locale) }}
</p>
<h3>{{ aiTrans('PROHIBICIÓN DE ENLACES AL SITIO WEB, CO-BRANDING, "FRAMING" Y/O REFERENCIA AL SITIO WEB', $locale) }}</h3>
<p>
    {{ aiTrans('Los enlaces al Sitio Web o partes del mismo en otro sitio web sin nuestra autorización expresa están prohibidos. El "framing" del Sitio Web o referirse al Uniform Resource Locator ("URL") sin nuestro permiso por escrito está estrictamente prohibido. La cooperación para eliminar dicho contenido o actividad es obligatoria, y usted es responsable de cualquier daño asociado.', $locale) }}
</p>
<h3>{{ aiTrans('EDICIÓN, ELIMINACIÓN Y MODIFICACIÓN', $locale) }}</h3>
<p>
    {{ aiTrans('Nos reservamos el derecho de editar y/o eliminar cualquier documento, información o contenido en el Sitio Web sin previo aviso.', $locale) }}
</p>
<h3>{{ aiTrans('EXENCIÓN DE RESPONSABILIDAD', $locale) }}</h3>
<p>
    {{ aiTrans('El SITIO WEB, SERVICIOS, CONTENIDO Y CUALQUIER PRODUCTO DE TERCEROS SE PROPORCIONAN "TAL CUAL" Y "SEGÚN DISPONIBILIDAD", CON TODAS LAS GARANTÍAS, EXPRESAS E IMPLÍCITAS, EXCLUIDAS EN LA MEDIDA MÁXIMA PERMITIDA POR LA LEY APLICABLE. NO GARANTIZAMOS QUE EL SITIO WEB, SERVICIOS, CONTENIDO Y/O PRODUCTOS DE TERCEROS CUMPLAN CON SUS REQUISITOS O SERÁN ININTERRUMPIDOS, OPORTUNOS, SEGUROS O LIBRES DE ERRORES. USTED ACEPTA QUE NO SOMOS RESPONSABLES POR CUALQUIER RECLAMACIÓN RELACIONADA CON LA INCAPACIDAD DE USAR EL SITIO WEB, SERVICIOS, CONTENIDO Y/O PRODUCTOS DE TERCEROS. EL SITIO WEB PUEDE CONTENER FALLAS, ERRORES O LIMITACIONES, Y NO SOMOS RESPONSABLES POR LA DISPONIBILIDAD DE LA CONEXIÓN A INTERNET.', $locale) }}
</p>
<h3>{{ aiTrans('LIMITACIÓN DE RESPONSABILIDAD', $locale) }}</h3>
<p>
    {{ aiTrans('NO SOMOS RESPONSABLES POR DAÑOS DIRECTOS, INDIRECTOS, INCIDENTALES, ESPECIALES O EJEMPLARES, INCLUYENDO PÉRDIDA DE GANANCIAS, BUENA VOLUNTAD, USO, DATOS U OTRAS PÉRDIDAS INTANGIBLES. ESTA LIMITACIÓN SE APLICA A TODAS LAS CAUSAS DE ACCIÓN, INCLUYENDO INCUMPLIMIENTO DE CONTRATO, GARANTÍA, NEGLIGENCIA, RESPONSABILIDAD OBJETIVA, DECLARACIONES FALSAS Y CUALQUIER OTRO DELITO. USTED NOS LIBERA A NOSOTROS Y A NUESTROS PROVEEDORES DE TERCEROS DE OBLIGACIONES, RESPONSABILIDADES Y RECLAMACIONES MÁS ALLÁ DE LA LIMITACIÓN INDICADA. SI LA LEY APLICABLE NO PERMITE ESTA LIMITACIÓN, NUESTRA RESPONSABILIDAD MÁXIMA EN CUALQUIER CIRCUNSTANCIA SERÁ DE QUINIENTOS DÓLARES ($500,00).', $locale) }}
</p>
<h3>{{ aiTrans('INDENNIZACIÓN', $locale) }}</h3>
<p>
    {{ aiTrans('Usted acepta indemnizarnos y eximirnos, a nosotros, nuestros socios, subsidiarias, afiliadas y sus respectivos miembros, directores, empleados, agentes y socios de cualquier reclamo, gasto, daño, procedimiento, costo, demanda y/o juicio realizado por terceros debido o resultante de su uso del Sitio Web, Servicios o Contenido; su violación de estos Términos; y/o su violación de los derechos de otro individuo y/o entidad.', $locale) }}
</p>
<h3>{{ aiTrans('SITIOS WEB DE TERCEROS', $locale) }}</h3>
<p>
    {{ aiTrans('El Sitio Web puede proporcionar enlaces a otros sitios web y/o recursos de Internet pertenecientes a Proveedores Externos. No somos responsables por la disponibilidad de tales sitios web y/o recursos de terceros, ni por sus contenidos, y no respaldamos ni asumimos responsabilidad por sus términos, políticas de privacidad, contenido, publicidad, servicios, productos o materiales.', $locale) }}
</p>
<h3>{{ aiTrans('POLÍTICA DE PRIVACIDAD/INFORMACIÓN DE LOS VISITANTES', $locale) }}</h3>
<p>
    {{ aiTrans('Su uso del Sitio Web y todos los comentarios, retroalimentación, información, datos de Registro y/o materiales enviados están sujetos a nuestra Política de Privacidad. Nos reservamos el derecho de usar la información sobre su uso del Sitio Web y la información personalmente identificable de acuerdo con nuestra Política de Privacidad y las leyes de protección de datos aplicables.', $locale) }}
</p>
<h3>{{ aiTrans('ADVERTENCIA LEGAL', $locale) }}</h3>
<p>
    {{ aiTrans('Cualquier intento de dañar, destruir, adulterar, vandalizar o interferir con la operación del Sitio Web es una violación de la ley penal y civil. Buscaremos recursos contra cualquier individuo o entidad infractora en la medida máxima permitida por la ley penal y equidad.', $locale) }}
</p>
<h3>{{ aiTrans('ELECCIÓN DE LEY Y FORO', $locale) }}</h3>
<p>
    {{ aiTrans('Estos Términos están regidos e interpretados de acuerdo con las leyes del Reino Unido. Las Partes intentarán negociar un acuerdo de buena fe para cualquier reclamo o disputa derivada o relacionada con estos Términos y Condiciones de manera amistosa. Si las Partes no llegan a un acuerdo, la disputa será sometida exclusivamente a procedimientos de arbitraje confidenciales ante un solo árbitro en Londres, bajo las reglas de la ICC, cuyo laudo será definitivo y vinculante. Ninguna parte debe presentar una reclamación ante el tribunal local de su domicilio o cualquier otro foro.', $locale) }}
</p>
<h3>{{ aiTrans('ANEXO DE PROTECCIÓN DE DATOS', $locale) }}</h3>


<p>
    {{ aiTrans('Este Anexo de Protección de Datos forma parte de nuestros Términos y Condiciones. Los términos aquí utilizados tienen significados especificados en este Anexo. Excepto según lo modificado a continuación, los Términos permanecen en pleno vigor y efecto.', $locale) }}
</p>
<ol class="nested-list">
    <li>
        <b>{{ aiTrans('Definiciones', $locale) }}</b>
        <ol class="nested-list">
            <li>
                <b>{{ aiTrans('Leyes Aplicables:', $locale) }}</b> {{ aiTrans('Leyes de la UE o del Estado Miembro sobre Datos Personales sujetos a las Leyes de Protección de Datos de la UE y otras leyes aplicables para Datos Personales sujetos a otras Leyes de Protección de Datos.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('Controlador:', $locale) }}</b> {{ aiTrans('Entidad que determina los fines y los medios del procesamiento de Datos Personales.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('Leyes de Protección de Datos:', $locale) }}</b> {{ aiTrans('Leyes de Protección de Datos de la UE y leyes de protección de datos o privacidad de cualquier otro país.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('Leyes de Protección de Datos de la UE:', $locale) }}</b> {{ aiTrans('Directiva 95/46/CE de la UE, GDPR y leyes relacionadas.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('GDPR:', $locale) }}</b> {{ aiTrans('Reglamento General de Protección de Datos de la UE 2016/679.', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('Recopilación y Procesamiento de Datos Personales', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('Nos comprometemos a cumplir con todas las Leyes de Protección de Datos aplicables en el Procesamiento de Datos Personales.', $locale) }}
                <ol class="nested-list">
                    <li>
                        {{ aiTrans('Declaramos y garantizamos que tenemos los permisos y los consentimientos necesarios de los titulares de los datos para permitir legalmente la recopilación, el procesamiento y el intercambio de Datos Personales a través de los Servicios de acuerdo con las Leyes Aplicables.', $locale) }}
                    </li>
                    <li>
                        {{ aiTrans('Mantendremos un mecanismo para obtener y retirar el consentimiento, de acuerdo con las Leyes Aplicables, y una política de privacidad disponible para el público.', $locale) }}
                    </li>
                    <li>
                        {{ aiTrans('Reconocemos que no proporcionamos Servicios a niños menores de dieciocho (18) años.', $locale) }}
                    </li>
                </ol>
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('Seguridad', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('Implementaremos medidas técnicas y organizacionales adecuadas para la seguridad de los datos de acuerdo con el Artículo 32(1) del GDPR.', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('Subprocesamiento', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('Nos autoriza a nombrar Subprocesadores y garantizar que los contratos escritos con Subprocesadores ofrezcan el mismo nivel de protección para los Datos Personales según lo descrito en este Anexo y cumplan con los requisitos del GDPR.', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('Derechos de los Titulares de Datos', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('Ayudaremos a responder a solicitudes de derechos de los Titulares de Datos de acuerdo con las Leyes de Protección de Datos, considerando la naturaleza del Procesamiento.', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('Violación de Datos Personales', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('Informaremos de inmediato a los Titulares de Datos afectados al tomar conocimiento de una Violación de Datos Personales, ayudando en la investigación, mitigación y remediación.', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('Términos Generales', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('Las disputas o reclamaciones derivadas de estos Términos están sujetas a la jurisdicción aquí estipulada. Si alguna disposición es inválida, el resto permanecerá válido.', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('Modificaciones', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('Las modificaciones a estos Términos pueden realizarse de vez en cuando a nuestra exclusiva discreción', $locale) }}
            </li>
        </ol>
    </li>
</ol>
<p>
    {{aiTrans('Al aceptar estos Términos y Condiciones, usted reconoce que ha leído, entendido
                    y acepta estar vinculado por todos los términos descritos anteriormente. Su uso continuo del Sitio Web
                    y Servicios constituye la aceptación de estos términos. Si tiene alguna pregunta o inquietud,
                    contáctenos a')}} <span >info{{ '@'.$website_title }}</span>
</p>
<script>
    const emails = document.getElementsByClassName('email');
    for (const email of emails) {
        email.innerText = `info@${location.hostname}`;
    }
</script>

            </div>
        </div>
    </div>
@endsection
