@extends('layouts.app')

@section('content')
<div class="hero wf-section">
    <div class="container w-container">
        <h1 class="hero-header">{{$website_title}}</h1>
        <h3 class="hero-subtitle">
            {{ aiTrans(
                "A kriptovaluta-kereskedelem forradalmasítása: bemutatjuk a legújabb frissítést a [website_title] platformon",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h3>
        <div class="main-cols">
            <div class="video-col"><img src="dist/images/poster_index.webp" sizes="(max-width: 479px) 100vw, (max-width: 767px) 96vw, (max-width: 991px) 97vw, 62vw" srcset="{{ asset('frontend/assets/pt/dist') }}/images/poster_index-p-500.webp 500w, {{ asset('frontend/assets/pt/dist') }}/images/poster_index.webp 733w" alt="{{$website_title}} - A kriptovaluta-kereskedelem forradalmasítása: bemutatjuk a legújabb frissítést a {{$website_title}} platformon" width="710" height="399" class="main-image"></div>
            <div class="form-col">
                <div class="form-container">
                    <div id="formTop" class="form-box w-form-wrapper">
                        @include('frontend.hu.components.form')
                        <div class="w-form-done">
                            <div>{{aiTrans('Köszönjük! A beküldését megkaptuk!')}}</div>
                        </div>
                        <div class="w-form-fail">
                            <div>{{aiTrans('Hoppá! Valami hiba történt az űrlap beküldése közben.')}}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="hero-bg-2"></div>
    <div class="hero-bg-1"></div>
</div>
<div class="trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/trade-image.webp" width="500" alt="{{$website_title}} - Mi az a {{$website_title}}?" class="img-float-right no-float-on-991">
    <div class="container w-container">
        <h2 class="trading-title">
            {{ aiTrans(
                "Mi az a [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="trading-text">
            {{ aiTrans(
                "Örömmel jelentjük be a [website_title] új verziójának bevezetését – a végső platformot a kriptovaluta-kereskedelemhez. Fejlett funkciókkal, csúcstechnológiával és felhasználóbarát felülettel az új [website_title] célja, hogy a kereskedési élményét új szintre emelje. A hatékony és intuitív kereskedési szoftver képes kihasználni a digitális pénznemek árkülönbségeit a különböző tőzsdéken. Ezután alacsony áron vásárol kriptovalutákat, majd magasabb áron értékesíti azokat. Az eredmény kisebb nyereségek sorozata, amely végül nagyobb profitot jelent a felhasználónak.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button margin-bottom-35 w-button">{{aiTrans("Regisztráljon most")}}</a>
        </div>
        <h2 class="trading-title">{{aiTrans('Hogyan kezdhetek online kereskedni?')}}</h2>
        <div class="trading-text">{{aiTrans('Az online kereskedés, azaz a pénzügyi eszközök interneten keresztüli vételének és eladásának alapelve, gyakorlatilag bárki számára elérhető, függetlenül a korábbi pénzügyi tapasztalataitól. Bár a kezdés egyszerű, ha profitot szeretne termelni, a kereskedés kihívást jelenthet. Az online kereskedés megkezdéséhez szüksége lesz egy számítógépre és stabil internetkapcsolatra. Miután regisztrált egy számlát egy megbízható platformon, a fiókja aktiválása és finanszírozása után megkezdheti a kereskedést. Érdekes módon, bár a kereskedés megkezdése egyszerű, a siker elérése sokkal nehezebb. Számos kockázattal kell tisztában lennie. A kereskedés nagyrészt módszeres tervezésről, pontos piaci elemzésről, az ármozgásokat befolyásoló tényezők megértéséről, valamint próbálkozásokról és hibázásokról szól. Egyes piacok nagyon volatilisek lehetnek, ami növelheti a veszteség kockázatát, ha nem rendelkezik a megfelelő készségekkel. Azonban az algoritmikus technológia fejlődésének köszönhetően a kereskedési szoftverek segítségével az online kereskedés ma már pontosabb és könnyebb, mint valaha. Az alkalmazás algoritmusa elemzi a piacokat, hogy azonosítsa a kereskedési lehetőségeket, és ezzel az információval intelligensebb döntéseket hozhat. Így még a kezdők is elkezdhetik a kedvenc eszközeik online kereskedését.')}}</div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("Regisztráljon most")}}</a>
            <div class="trading-bg2"></div>
        </div>
    </div>
    <div class="trading-bg-1"></div>
</div>
<div class="not-scam w-clearfix wf-section">
    <div class="not-scam-bg-1"></div>
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/not-scam-img.webp" alt="{{$website_title}} - {{$website_title}} átverés?" class="img-float-right not-scam-img">
    <div class="container w-container">
        <h3 class="not-scam-title">
            {{ aiTrans(
                "[website_title] átverés?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h3>
<p class="not-scam-text">
    {{ aiTrans(
        "Nem, nem az. [website_title] nem ígér garantált kriptovaluta-kereskedelmi nyereséget, mert nem egy automatizált kereskedési szoftver. Az alkalmazás csak egy kereskedési segéd. Azért készült, hogy segítsen a befektetőknek bizalommal kereskedni a kriptovalutákkal. Az alkalmazás valós idejű adatokat biztosít a kereskedőknek, segítve őket a gyors és pontos döntéshozatalban, amikor a kedvenc kriptovalutáikat online kereskednek. Ezen kívül az alkalmazás biztonságos, és nem veszélyezteti a felhasználók személyes vagy pénzügyi adatait.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</p>
<div class="button-wrapper">
    <a href="#formTop" class="button white w-button">{{aiTrans("REGISZTRÁLJ MOST")}}</a>
</div>
</div>
</div>
<div class="improve-your-trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/improve-your-trading-img.webp" alt="{{$website_title}} - Hogyan javítja a {{$website_title}} alkalmazás a kereskedését?" class="img-float-right improve-your-trading-img">
    <div class="container w-container">
        <h2 class="improve-your-trading-title">
            {{ aiTrans(
                "Hogyan javítja a [website_title] alkalmazás a kereskedését?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="improve-your-trading-text">
            {{ aiTrans(
                "Nem számít, milyen szintű kereskedési tapasztalattal rendelkezik, a [website_title] alkalmazás erőteljes kereskedési funkcióiból mindenki hasznot húzhat. Először is, meg kell értenie, hogyan működik a szoftver. A [website_title] képes elemezni a piacokat egy rendkívül fejlett algoritmus segítségével, amely nagy mennyiségű piaci adatot, valamint néhány fontos technikai indikátort használ a magas valószínűségű kereskedési beállítások azonosításához. A szoftver intuitív felhasználói felületén a paramétereket is beállíthatja. Egyszerűen igazíthatja a szoftver működését saját kereskedési tapasztalata, kockázattűrő képessége és preferenciái szerint. A szoftver lehetővé teszi, hogy még a kezdők is elkezdjék a kereskedést a piacokon anélkül, hogy aggódnának amiatt, hogy hibát követnek el az ármozgások elemzésekor, és tudják, mikor kell belépniük egy ügyletbe. Ezen kívül, ha elkezd fejlődni mint kereskedő, előfordulhat, hogy egy praktikusabb megközelítést szeretne alkalmazni. Ilyenkor a szoftver még mindig hasznos lehet a saját piaci elemzésének megerősítésére, mielőtt belép egy ügyletbe. Még magasabb szintű készségekkel is előfordulhat, hogy olyan helyzetekben találja magát, amikor túl ideges vagy izgatott ahhoz, hogy logikus kereskedési döntéseket hozzon. Ilyen esetekben használhatja az alkalmazás által biztosított piaci elemzést. Ez lehetővé teszi, hogy elkerülje az érzelmi kereskedés hibáját, és biztos lehet abban, hogy adat-alapú piaci elemzés alapján hoz döntéseket. Az egyik legjobb dolog a [website_title]-ban, hogy teljesen ingyenes regisztrálni az új fiókot. Regisztráljon most, és kezdje el a kereskedést a piacokon.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans('Nyisson ingyenes fiókot most')}}</a>
        </div>
        <div class="improve-your-trading-bg"></div>
    </div>
    <div class="improve-your-trading-bg-2"></div>
</div>
<div class="features wf-section">
    <div class="container w-container">
        <div class="features-bg"></div>
        <h2 class="features-title">
            {{ aiTrans(
                "[website_title] legfontosabb jellemzői",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="features-text">
            {{ aiTrans(
                "[website_title] a legújabb verziója a hatékony kereskedési alkalmazásunknak, amely segít a befektetőknek hozzáférni és kihasználni a legjobb kriptovaluta-kereskedési lehetőségeket. Fejlett pénzügyi technológiáink több mint 15 technikai elemző eszközt kombinálnak, hogy segítsenek a kereskedőknek az ideális belépési és kilépési pontok azonosításában kedvenc digitális pénznemük kereskedésekor. Az új [website_title] szélesebb kriptovaluta választékot kínál, így több lehetőség is rendelkezésre áll a kereskedéshez. Legyen szó Bitcoinnal, Ethereumról vagy más népszerű kriptovalutákról, mindegyiket kereskedhet az új [website_title] segítségével.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
        <div class="features-list w-row">
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature1-icon.webp" alt="{{$website_title}} - Fejlett Kereskedési Algoritmusok" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Fejlett Kereskedési Algoritmusok')}}</h3>
                    </div>
                    <div class="features-list-item-text">{{aiTrans('A kereskedési algoritmusaink most erősebbek, mint valaha, lehetővé téve, hogy valós időben kihasználja a piaci mozgásokat. A gépi tanulás fejlett algoritmusai segítségével a [website_title] képes piaci adatokat elemezni és előrejelzéseket készíteni a jövőbeni ármozgásokról, így előnyt biztosítva Önnek a kereskedéseiben.', $locale , ['website_title' => $website_title])}}</div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature2-icon.webp" alt="{{$website_title}} - Fejlettebb felhasználói felület" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Fejlettebb felhasználói felület')}}</h3>
                    </div>
                    <div class="features-list-item-text">
                        
                        {{ aiTrans(
                            "Teljesen átterveztük a felhasználói felületünket, hogy intuitívabbá és könnyebben használhatóvá váljon. Legyen szó kezdőről vagy tapasztalt kereskedőről, az új [website_title] alkalmazás könnyen navigálható és használható lesz.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature3-icon.webp" alt="{{$website_title}} - Fejlettebb biztonság" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Fejlettebb biztonság')}}</h3>
                    </div>
                    <div class="features-list-item-text">
                        {{ aiTrans(
                            "A biztonság az elsődleges prioritásunk a [website_title]-ban, és az új platformunk számos fejlett biztonsági funkcióval rendelkezik, hogy pénzeszközeit és személyes adatait biztonságban tartsa. Platformunk SSL titkosítással és kéttényezős hitelesítéssel van védve, és a legújabb biztonsági protokollokat használjuk az adatai védelme érdekében.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
        </div>
        <div class="button-wrapper margin-0-auto">
            <a href="#formTop" class="button w-button">{{aiTrans("REGISZTRÁLJ MOST")}}</a>
        </div>
    </div>
    <div class="featues-bg-1"></div>
</div>
<div class="steps wf-section">
    <div class="container w-container">
        <h2 class="steps-title">
            {{ aiTrans(
                "Hogyan regisztrálhatsz a [website_title]-ra?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="steps-list w-row">
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Első lépés')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Regisztráció')}}</h3>
                    </div>
                    <div>
                        {{ aiTrans(
                            "Az első lépés a regisztrációs űrlap kitöltése, amelyet a weboldalunkon találhat. Kérni fogják, hogy adja meg alapvető adatait, mint például a nevét, családi nevét, e-mail címét és telefonszámát. Miután megkapta a megerősítő e-mailt és rákattintott a megerősítő linkre, regisztrált lesz és az új fiókja aktiválódik. Ez azt jelenti, hogy teljes hozzáférése lesz a [website_title] kereskedési alkalmazáshoz.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Második lépés')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Pénzesítés')}}</h3>
                    </div>
                    <div>
                        {{ aiTrans(
                            "Miután aktiválta új fiókját, pénzt kell befizetnie a fiókjába. A kereskedéshez tőkére van szükség, hogy fenntartja a pozíciókat a piacon. Kötelező minimális összeget befizetni, hogy kereskedéseket végezhessen a [website_title] alkalmazással. Minél többet fektet be, annál nagyobb potenciális profitot érhet el. Azonban ez magasabb veszteségkockázattal is jár. Kezdőknek azt javasoljuk, hogy kezdjék kicsiben, és csak a minimális letétet fektessék be. Ez lehetővé teszi, hogy megtanulja a kereskedési piacok alapjait, mielőtt többet fektet be.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Harmadik lépés')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Kereskedés')}}</h3>
                    </div>
                    <div>{{aiTrans('Végül, be kell állítania a kereskedési paramétereket a szoftverben. Az alkalmazás személyre szabható, hogy megfeleljen a saját kockázattűrő képességének, preferenciáinak és kereskedési céljainak. Ez biztosítja, hogy a lehető legjobb kereskedési élményt nyújtsa Önnek. Miután befejezte a kereskedési paraméterek beállítását, készen áll arra, hogy elkezdje a kereskedést a hatékony algoritmusunkkal és piaci elemzésünkkel.')}}</div>
                </div>
            </div>
        </div>
        <div class="button-wrapper steps-action-button">
            <a href="#formTop" class="button white w-button">{{aiTrans('Jelentkezzen most és kezdje el!')}}</a>
        </div>
    </div>
</div>
<div class="faq wf-section">
    <div class="container w-container">
        <h2 class="faq-title">{{aiTrans('Gyakran ismételt kérdések')}}</h2>
        <p class="faq-text">{{aiTrans('Valószínűleg még mindig van néhány kérdése, hogyan működik a kereskedési alkalmazásunk. Ha kezdő kereskedő, valószínűleg kétségei vannak arról, hogyan kell elkezdenie. Az alábbiakban néhány gyakran feltett kérdést talál, amelyeket a kereskedőktől hallottunk.')}}</p>
        <div class="faq-accordion">
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">1</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Mi az új verziója a [website_title]-nak?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "A [website_title] új verziója egy frissített változata a népszerű kriptovaluta-kereskedési platformnak, amely célja, hogy még hatékonyabb eszközöket és funkciókat biztosítson a kereskedőknek, hogy sikeresebbek legyenek a kriptovaluták piacán.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">2</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Milyen új funkciókat kínál az új verzió a [website_title]-nak?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "A [website_title] új verziója számos új funkcióval rendelkezik, többek között fejlett kockázatkezelő eszközökkel, valós idejű piaci adatokkal, testreszabható táblázatokkal és grafikonnal, valamint hírelemzéssel és eseményelemzéssel.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">3</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Biztonságos az új verziója a [website_title]-nak?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Igen, az új verziója a [website_title]-nak biztonságos. A platform fejlett biztonsági intézkedéseket használ a felhasználói adatok és tranzakciók védelme érdekében, és szakértői csapatunk 24/7 figyeli a platformot, hogy biztosítsa a biztonságot és megbízhatóságot.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">4</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Személyre szabhatom a kereskedési élményemet az új verzióval a [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Igen, az új verziója a [website_title]-nak lehetővé teszi a kereskedési élményének személyre szabását, beleértve az testreszabható táblázatokat és grafikonokat, amelyek lehetővé teszik a piaci adatok és trendek könnyű megtekintését.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">5</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "A [website_title] új verziója alkalmas kezdők számára?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Igen, az új verziója a [website_title]-nak alkalmas kezdők számára. A platform felhasználóbarát és könnyen navigálható, és szakértői csapatunk rendelkezésre áll, hogy útmutatást és támogatást nyújtson minden tapasztalati szintű kereskedő számára.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("REGISZTRÁLJ MOST")}}!</a>
        </div>
    </div>
    <div class="faq-bg-2"></div>
    <div class="faq-bg-3"></div>
</div>
<div class="highlights-section wf-section">
    <div class="container w-container">
        <h2 class="faq-title">
            {{ aiTrans(
                "[website_title] Legfontosabb jellemzők",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="high-table">
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-1.webp" alt="Jellemzők" class="high-img">
                    <div class="high-text">{{aiTrans('Típus')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('AI Kereskedési Robot')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Jellemzők" class="high-img">
                    <div class="high-text">{{aiTrans('Alkalmazás költsége')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Ingyenes')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-3.webp" alt="Jellemzők" class="high-img">
                    <div class="high-text">{{aiTrans('Díjak')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Nincs')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-4.webp" alt="Jellemzők" class="high-img">
                    <div class="high-text">{{aiTrans('Demó fiók')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Igen')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Jellemzők" class="high-img">
                    <div class="high-text">{{aiTrans('Eszközök')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('BTC, ETH, XRP, DASH és mások')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-6.webp" alt="Jellemzők" class="high-img">
                    <div class="high-text">{{aiTrans('Felhasználói adatok védelme')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Igen')}}</div>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection
