@extends('layouts.app')
@section('title', $website_title .' | DESPRE NOI')
@php( $meta_description = "Descoperă cum ". $website_title." ajută la dezvoltarea abilităților tale de investiții în criptomonede. Oferim instrumente avansate și suport complet pentru a-ți atinge obiectivele de tranzacționare.")

@section('content')
<div class="what-is w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/what-is-img.webp"  sizes="(max-width: 991px) 100vw, (max-width: 2870px) 50vw, 1435px" alt="{{$website_title}}  - Ce este exact tranzacționarea online?" class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h1 class="about-title">{{aiTrans('Despre noi')}}</h1>
        <h2 class="about-subtitle">{{aiTrans('Ce este exact tranzacționarea online?')}}</h2>
        <p>{{aiTrans('Tranzacționarea online a început în 1971, când a fost lansat primul software de tranzacționare, National Association of Securities Dealers Automated Quotations (NASDAQ), ca primul software de tranzacționare online. Astăzi, tranzacționarea online este metoda cea mai populară de a efectua cumpărarea și vânzarea diverselor active financiare, cum ar fi Forex, criptomonede, acțiuni, mărfuri și chiar contracte pentru diferențe (CFD-uri).')}}</p>
        <p>
            
            {{ aiTrans(
                "Pe baza acestui fapt, a luat naștere [website_title] .",
                $locale,
                ['website_title' => $website_title],
            ) }}</p>
        <p>{{aiTrans('Software-ul de tranzacționare puternic și intuitiv este capabil să profite de diferențele mici de preț ale monedelor digitale între diferitele burse. Apoi, acesta va cumpăra criptomonede la un preț mic și le va vinde la un preț mai mare. Rezultatul final sunt mici profituri care duc la câștiguri mari pentru utilizator.')}}</p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Vizionați video-ul')}}</a>
        </div>
    </div>
    <div class="what-is-bg-1"></div>
</div>

<div class="how-it-working wf-section">
    <div class="container w-container">
        <div class="how-it-working-text">
            
            {{ aiTrans(
                "Criptomonedele sunt active extrem de volatile și este important să iei decizii bune atunci când le tranzacționezi. Acesta este scopul [website_title] . Aplicația puternică garantează că investitorii în criptomonede pot accesa informații rapide și relevante atunci când tranzacționează monedele și tokenurile lor preferate pe piață. Astfel, aceștia pot urmări cele mai bune oportunități de pe piețele de criptomonede și pot lua decizii de tranzacționare precise și informate în permanență. [website_title] garantează practic că niciun investitor cripto nu va tranzacționa orbește. Aplicația îți permite să tranzacționezi cu încredere și să profiți la maximum de activitatea ta comercială.",
                $locale,
                ['website_title' => $website_title],
            ) }}</div>
    </div>
</div>

<div class="our-team w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/our-team-img.webp"  sizes="(max-width: 991px) 100vw, 50vw" alt="{{$website_title}}  - Echipa {{$website_title}} " class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-team-title">
            {{ aiTrans(
                "Echipa [website_title] ",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "Echipa [website_title]  este formată din profesioniști dedicați în tranzacționare care doresc să ofere oamenilor obișnuiți, ca și tine, oportunitatea de a tranzacționa Bitcoin și alte criptomonede într-un mod eficient și profitabil. Echipa a combinat cunoștințele și experiența lor pentru a crea o soluție software de tranzacționare capabilă să scaneze rapid și ușor diferitele burse de criptomonede și să identifice oportunități profitabile de tranzacționare. Întregul proces a fost automatizat, permițând oricui să tranzacționeze și să obțină partea sa din această oportunitate profitabilă.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "[website_title]  oferă multe beneficii și avantaje și ne angajăm mereu să contribuim pozitiv la experiența ta comercială și călătoria ta financiară.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Înregistrează-te acum')}}</a>
        </div>
    </div>
</div>
<div class="our-advantage w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/advantage-img.webp"  alt="{{$website_title}}  - Profită de piețele criptografice și câștigă cu [website_title]" class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-advantage-title">
            {{ aiTrans(
                "Profită de piețele criptografice și câștigă cu [website_title] ",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "La [website_title] , vrem să te ajutăm să atingi libertatea financiară și, pe măsură ce piața criptomonedelor crește și se dezvoltă, nu există nicio îndoială că vor apărea mai multe oportunități de tranzacționare. Acest lucru înseamnă pur și simplu mai multe profituri pentru tine.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "Ia controlul asupra viitorului tău astăzi și înscrie-te cu [website_title] . Succesul tău îți va schimba viața. Înregistrează-te acum pentru contul tău gratuit și intră în acțiunea de tranzacționare astăzi!",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
    </div>
</div>
@endsection
