@extends('layouts.app')
@section('title', $website_title .' | Integritetspolicy')
@php( $meta_description = "Upptäck hur ". $website_title." skyddar din personliga information. Vår integritetspolicy beskriver de åtgärder vi vidtar för att säkerställa säkerheten och transparensen för din information.")

@section('content')
<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>INTEGRITETSPOLICY</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
            </p>
            <h3>{{ aiTrans('1. Introduktion', $locale) }}</h3>
            <p>
                {{ aiTrans('Detta uttalande beskriver integritetspolicyn som antagits av', $locale) }} {{ $website_title }} ("{{ aiTrans('vi', $locale) }}," "{{ aiTrans('vår', $locale) }}," "{{ aiTrans('eller', $locale) }}")
                {{ aiTrans('gällande våra produkter och tjänster ("Tjänster") och', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('webbplats', $locale) }}</a>
                {{ aiTrans('("Webbplats")', $locale) }}. {{ aiTrans('Att skydda din integritet och konfidentialiteten av din information är avgörande för oss när vi tillhandahåller våra Tjänster och driver Webbplatsen.', $locale) }}
            </p>
            <p>
                {{ aiTrans('Våra Tjänster och Webbplats kan innehålla länkar till webbplatser och tjänster från tredje part. Vi ansvarar inte för integritetspraxis för dessa externa parter. Vi rekommenderar att du granskar deras integritetspolicy innan du använder dem.', $locale) }}
            </p>
            <p>
                {{ aiTrans('All information som vi erhåller i samband med våra Tjänster behandlas som konfidentiell. Vi använder robusta tekniska, säkerhets- och organisatoriska åtgärder för att skydda Personuppgifter (som definieras nedan) mot obehörig behandling, oavsiktlig förlust, förstörelse, skada, stöld eller utlämning.', $locale) }}
            </p>
            <p>
                {{ aiTrans('När du skickar din information genom vår webbplats kan du bli ombedd att ange personlig information, såsom ditt namn, e-postadress, telefonnummer, födelsedatum och olika identifieringsuppgifter. Denna information kan användas för olika ändamål, bland annat för att verifiera identitet, administrera information, erbjuda teknisk support och uppfylla kontrakts- och lagstadgade skyldigheter. Vi kan kommunicera viktiga detaljer genom meddelanden, och med ditt samtycke kan vi tillhandahålla information om produkter och tjänster via SMS, e-post etc. Du har möjlighet att hantera meddelandeinställningar och avregistrera dig från vissa kommunikationer.', $locale) }}
            </p>
            <h3>{{ aiTrans('2. Webbplats; Besökare och Användare', $locale) }}</h3>
            <h4>{{ aiTrans('2.1. Allmänt', $locale) }}</h4>
<p>
    {{ aiTrans('Denna sektion beskriver specifikationerna för insamling av data från olika grupper: webbplatsbesökare ("Besökare"), användare ("Användare") och affärspartners (tillsammans "Partners"). Personuppgifter inkluderar IP-adress, namn, kontaktinformation och information om relationen med oss, enligt de tillämpliga dataskyddsregleringarna.', $locale) }}
</p>
<h4>{{ aiTrans('2.2. Insamling och Användning', $locale) }}</h4>
<p>
    {{ aiTrans('Genom att besöka Webbplatsen samtycker du till insamling och användning av dina Personuppgifter. Om du inte godkänner dessa villkor bör du inte besöka Webbplatsen. Vi kan samla in information genom aktivitet som sidvisningar, IP-adresser och cookies. Dessutom bearbetar vi uppgifter som frivilligt tillhandahålls via formulär och registreringar.', $locale) }}
</p>
<h4>{{ aiTrans('2.3. Syfte med Behandling av Personuppgifter', $locale) }}</h4>
<p>
    {{ aiTrans('Vi behandlar Personuppgifter för att förbättra, förstå och anpassa vår Webbplats och Tjänster. Detta inkluderar att förbättra noggrannhet, kommunikation om Tjänster, support, kontraktsförpliktelser och samarbete med partners. Samtycke eller rättslig grund är nödvändigt för all behandling.', $locale) }}
</p>
<p>{{ aiTrans('Följande beskriver syften och den rättsliga grunden för behandlingen av Personuppgifter:', $locale) }}</p>
<table>
    <tbody>
        <tr>
            <td>{{ aiTrans('Registrering som kontoinnehavare', $locale) }}</td>
            <td>{{ aiTrans('Ditt samtycke; Utförande av Tjänster eller kontraktsförpliktelser', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Tillhandahållande och användning av Tjänster', $locale) }}</td>
            <td>{{ aiTrans('Utförande av Tjänster eller kontraktsförpliktelser', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Operativa uppdateringar', $locale) }}</td>
            <td>{{ aiTrans('Utförande av Tjänster eller kontraktsförpliktelser', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Svara på förfrågningar och ge support', $locale) }}</td>
            <td>{{ aiTrans('Legitima intressen eller utförande av Tjänster', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Tjänster, annonsering och skräddarsydd marknadsföring', $locale) }}</td>
            <td>{{ aiTrans('Legitima intressen eller ditt samtycke', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Förbättring och erbjudande av nya Tjänster', $locale) }}</td>
            <td>{{ aiTrans('Samtycke och legitima intressen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Skicka reklammaterial och marknadsföring', $locale) }}</td>
            <td>{{ aiTrans('Ditt samtycke', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Analys av effektiviteten av marknadsföringskampanjer', $locale) }}</td>
            <td>{{ aiTrans('Legitima intressen eller samtycke', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Utförande av olika supportaktiviteter', $locale) }}</td>
            <td>{{ aiTrans('Legitima intressen eller utförande av Tjänster', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Analys, inklusive statistisk analys', $locale) }}</td>
            <td>{{ aiTrans('Legitima intressen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Skydd av intressen, rättigheter och tillgångar', $locale) }}</td>
            <td>{{ aiTrans('Legitima intressen eller rättsliga förpliktelser', $locale) }}</td>
        </tr>
    </tbody>
</table>
<h4>{{ aiTrans('2.4. Dela Personuppgifter', $locale) }}</h4>
<p>
    {{ aiTrans('Vi kan dela information med tjänsteleverantörer, partners och entreprenörer. För besökare och användare inom det europeiska dataskyddsområdet, sker databehandling i enlighet med GDPR och tillämpliga dataskyddslagar.', $locale) }}
</p>
<h3>{{ aiTrans('3. Partners', $locale) }}</h3>
<h4>{{ aiTrans('3.1. Allmänt', $locale) }}</h4>
<p>
    {{ aiTrans('För att tillhandahålla Tjänster och samarbeta med Partners, samlar vi in och bearbetar specifika typer av data. Partners ansvarar för sina egna data, och vi kan få tillgång till dem via säkra metoder.', $locale) }}
</p>
<h4>{{ aiTrans('3.2. Behandling av Personuppgifter', $locale) }}</h4>
<p>
    {{ aiTrans('Vi förlitar oss på samtycke från Partners eller legitima intressen för att bearbeta Personuppgifter. Aggerade data kan skapas för utveckling och förbättring av kvaliteten.', $locale) }}
</p>
<h4>{{ aiTrans('3.3. Personuppgiftsansvarig/Behandlare', $locale) }}</h4>
<p>{{ aiTrans('Vi kan agera som Personuppgiftsansvarig eller Behandlare beroende på typen av data:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Besökares/Användares data: Personuppgiftsansvarig', $locale) }}</li>
    <li>{{ aiTrans('Partners data: Behandlare', $locale) }}</li>
    <li>{{ aiTrans('Alla data är säkert lagrade enligt de högsta säkerhetsstandarderna. Vi implementerar fysiska, tekniska och organisatoriska skyddsåtgärder.', $locale) }}</li>
</ul>
<h4>{{ aiTrans('3.4. Skydd av Tredjepartsdata', $locale) }}</h4>
<p>{{ aiTrans('Om Tjänsterna involverar bearbetning av Personuppgifter på en tredjepartsplattform:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Vi agerar som Behandlare', $locale) }}</li>
    <li>{{ aiTrans('Följa tredjeparts instruktioner', $locale) }}</li>
    <li>{{ aiTrans('Implementera säkerhetsåtgärder', $locale) }}</li>
    <li>{{ aiTrans('Informera om dataintrång', $locale) }}</li>
    <li>{{ aiTrans('Inget underleverantörsansvar utan samtycke', $locale) }}</li>
    <li>{{ aiTrans('Inget bearbetande av data utanför det europeiska ekonomiska området utan samtycke', $locale) }}</li>
    <li>{{ aiTrans('För elektronisk marknadsföring garanterar vi samtycke och möjlighet att avregistrera sig.', $locale) }}</li>
</ul>
<h3>{{ aiTrans('4. Säkerhet', $locale) }}</h3>
<p>
    {{ aiTrans('Vi använder administrativa, organisatoriska och tekniska skyddsåtgärder för att skydda Personuppgifter mot obehörig åtkomst, avslöjande, ändring, förlust, missbruk eller otillåten skada. När vi delar data med tredje part säkerställer vi att de upprätthåller samma skyddsnivå för data, och kontraktsåtaganden etableras för exklusiv och säker behandling, i linje med denna Policy.', $locale) }}
</p>
<p>
    {{ aiTrans('Om det finns misstankar om att interaktionen med oss har blivit komprometterad, bör Besökare, Användare eller Partners snabbt meddela oss. Det är viktigt att notera att trots våra säkerhetsåtgärder, kan vi inte garantera fullständig immunitet mot tredjepartsangrepp. Användare erkänner de inneboende riskerna och eventuella överträdelser.', $locale) }}
</p>
<h3>{{ aiTrans('5. Cookies', $locale) }}</h3>
<p>
    {{ aiTrans('Se vår', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('Cookiepolicy', $locale) }}</a> {{ aiTrans('för detaljerad information om typerna av cookies och spårningstekniker som används på Webbplatsen, varför de används och hur du accepterar eller avvisar dem.', $locale) }}
</p>
<h3>{{ aiTrans('6. Länkar till Andra Webbplatser', $locale) }}</h3>
<p>
    {{ aiTrans('Under din användning av Webbplatsen kan Användare stöta på länkar till externa webbplatser som ligger utanför vår kontroll. Vi ansvarar inte för innehåll eller sekretesspolicyer för dessa webbplatser. Användare rekommenderas att granska sekretesspolicyerna för sådana webbplatser och tredjepartstjänster innan de avslöjar någon Personlig Information.', $locale) }}
</p>
<h3>{{ aiTrans('7. Lagring och Radering', $locale) }}</h3>
<p>
    {{ aiTrans('Personuppgifter, inklusive Personuppgifter, kommer inte att lagras längre än nödvändigt. Besökare och/eller Användare med aktiva konton ansvarar för att radera uppgifterna vid rätt tidpunkt. Efter att ett konto eller partnerskap har avslutats, kommer de Personuppgifter som samlats in via Webbplatsen och/eller Tjänsterna att raderas i enlighet med tillämpliga lagar och våra interna policyer.', $locale) }}
</p>
<p>
    {{ aiTrans('Återkallandet av samtycke för behandling av Personuppgifter kan begränsa tillgången till vissa eller alla begärda Tjänster, utan att några klagomål eller krav kan göras.', $locale) }}
</p>
<h3>{{ aiTrans('8. Dina Rättigheter', $locale) }}</h3>
<p>{{ aiTrans('Användare har specifika rättigheter gällande sina Personuppgifter:', $locale) }}</p>
<h4>{{ aiTrans('8.1. Rätt till Tillgång', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Bekräfta om Personuppgifter behandlas', $locale) }}</li>
    <li>{{ aiTrans('Få tillgång till Personuppgifter och relaterad information', $locale) }}</li>
    <li>{{ aiTrans('Information om syften för behandling, kategorier, mottagare, lagringstid, rättigheter och existens av profiler', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.2. Rätt till Rättning', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Rätta felaktiga Personuppgifter', $locale) }}</li>
    <li>{{ aiTrans('Komplettera ofullständiga Personuppgifter', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.3. Rätt till Radering', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Begära radering av Personuppgifter under specifika omständigheter', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.4. Rätt till Begränsning av Behandling', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Få begränsning av behandlingen under specifika omständigheter', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.5. Rätt till Dataportabilitet', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Ta emot Personuppgifter i ett strukturerat, maskinläsbart format', $locale) }}</li>
    <li>{{ aiTrans('Överföra Personuppgifter till en annan personuppgiftsansvarig', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.6. Rätt till Invändning', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Invända mot behandling baserat på legitima intressen eller direktmarknadsföring', $locale) }}</li>
    <li>{{ aiTrans('Stoppa behandlingen, om det inte finns övertygande och/eller tillämpliga rättsliga skäl', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.7. Rätt att Återkalla Samtycke', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Återkalla samtycke för behandling av Personuppgifter när som helst', $locale) }}</li>
</ul>
<h3>{{ aiTrans('9. Reklammaterial och Marknadsföring', $locale) }}</h3>
<p>
    {{ aiTrans('Samtycke erhålls för användning av Personuppgifter och kontaktinformation för att tillhandahålla reklammaterial och marknadsföring. Återkallande av samtycke är möjligt genom att skicka ett skriftligt meddelande till den angivna e-postadressen.', $locale) }}
</p>
<h3>{{ aiTrans('10. Accepterande av denna Policy', $locale) }}</h3>
<p>
    {{ aiTrans('Genom att använda Webbplatsen och/eller Tjänsterna antas Besökare, Användare och/eller Partners ha läst och godkänt denna Policy. Eventuella avvikelser innebär avhållsamhet från att använda plattformen. Vi förbehåller oss rätten att ändra Policyn, och Användare uppmanas att kontrollera uppdateringar regelbundet. Fortsatt användning efter ändringar innebär godkännande.', $locale) }}
</p>
<h3>{{ aiTrans('11. Laglig Skyldighet att Utlämna Personuppgifter', $locale) }}</h3>
<p>
    {{ aiTrans('Personuppgifter kan avslöjas utan föregående samtycke om det finns en tro på att det är nödvändigt för att fastställa identitet, kontakta eller inleda rättsliga förfaranden mot individer som misstänks för att ha kränkt rättigheter eller egendom. Utlämnandet sker när det krävs enligt lag.', $locale) }}
</p>
<h3>{{ aiTrans('12. Dataskyddsombud', $locale) }}</h3>
            <p>
                För frågor om integritet och dataskydd kan ett "Dataskyddsombud" kontaktas via e-post på <span >info{{ '@'.$website_title }}</span>
            </p>
            <script>
                const emails = document.getElementsByClassName('email');
                for (const email of emails) {
                    email.innerText = `info@${location.hostname}`;
                }
            </script>

        </div>
    </div>
</div>
@endsection
