<?php

use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'blog', 'as' => 'blog.', 'namespace' => 'Blog'], function () {
    Route::resources([
        'post-categories' => 'PostCategoryController',
        'posts' => 'PostController',
    ]);
    Route::get('publish-to-websites/{postId}', 'PostController@publish')
        ->name('posts.publish');
    Route::delete('post-categories-delete-multi', 'PostCategoryController@multiDestroy')
        ->name('post-categories.destroy.all');

    Route::delete('posts-delete-multi', 'PostController@multiDestroy')
        ->name('posts.destroy.all');
});
