<?php

use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'core', 'as' => 'core.', 'namespace' => 'Core'], function () {

    require __DIR__ . '/../../packages/codebase/page-builder/src/routes.php';

    route_group('administration', static function () {
        Route::get('profile', 'AdminProfileController@index')->name('profile');
        Route::put('profile', 'AdminProfileController@update')->name('users.update-profile');
        Route::resource('users', 'UserController');
        Route::resource('roles', 'RoleController');
    });
    Route::resources([
        'settings' => 'SettingController',
        'cities' => 'CityController',
        'countries' => 'CountryController',
        'areas' => 'AreaController',
        'states' => 'StateController',
        'sliders' => 'SliderController',
        'placeholders' => 'PlaceholderController',
        'branches' => 'BranchController',
        'companies' => 'CompanyController',
        'contacts' => 'ContactController',
        'problems' => 'ProblemController',
        'transactions' => 'TransactionController',
    ]);

    Route::delete('cities-delete-multi', 'CityController@multiDestroy')
        ->name('cities.destroy.all');

    // Route::resource('menus/footer' ,'MenuController');
});
